/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.EmbeddedServer;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.ServerInterface;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.EditionModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.index.Index;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class BackupIT {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.random);
    @Parameterized.Parameter
    public String recordFormatName;
    private File serverPath;
    private File otherServerPath;
    private File backupPath;
    private List<ServerInterface> servers;

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormatNames() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void before() {
        this.servers = new ArrayList<ServerInterface>();
        this.serverPath = this.testDir.directory("server");
        this.otherServerPath = this.testDir.directory("server2");
        this.backupPath = this.testDir.directory("backedup-serverdb");
    }

    @After
    public void shutDownServers() {
        for (ServerInterface server : this.servers) {
            server.shutdown();
        }
        this.servers.clear();
    }

    @Test
    public void makeSureFullFailsWhenDbExists() {
        int backupPort = PortAuthority.allocatePort();
        this.createInitialDataSet(this.serverPath);
        ServerInterface server = this.startServer(this.serverPath, backupPort);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
        this.createInitialDataSet(this.backupPath);
        try {
            backup.full(this.backupPath.getPath());
            Assert.fail((String)"Shouldn't be able to do full backup into existing db");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdownServer(server);
    }

    @Test
    public void makeSureIncrementalFailsWhenNoDb() {
        int backupPort = PortAuthority.allocatePort();
        this.createInitialDataSet(this.serverPath);
        ServerInterface server = this.startServer(this.serverPath, backupPort);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
        try {
            backup.incremental(this.backupPath.getPath());
            Assert.fail((String)"Shouldn't be able to do incremental backup into non-existing db");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdownServer(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backedUpDatabaseContainsChecksumOfLastTx() throws Exception {
        ServerInterface server = null;
        try {
            this.createInitialDataSet(this.serverPath);
            int backupPort = PortAuthority.allocatePort();
            server = this.startServer(this.serverPath, backupPort);
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            backup.full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            this.shutdownServer(server);
            server = null;
            PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
            long firstChecksum = this.lastTxChecksumOf(this.serverPath, pageCache);
            Assert.assertEquals((long)firstChecksum, (long)this.lastTxChecksumOf(this.backupPath, pageCache));
            this.addMoreData(this.serverPath);
            server = this.startServer(this.serverPath, backupPort);
            backup.incremental(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            this.shutdownServer(server);
            server = null;
            long secondChecksum = this.lastTxChecksumOf(this.serverPath, pageCache);
            Assert.assertEquals((long)secondChecksum, (long)this.lastTxChecksumOf(this.backupPath, pageCache));
            Assert.assertTrue((firstChecksum != secondChecksum ? 1 : 0) != 0);
            if (server != null) {
                this.shutdownServer(server);
            }
        }
        catch (Throwable throwable) {
            if (server != null) {
                this.shutdownServer(server);
            }
            throw throwable;
        }
    }

    @Test
    public void fullThenIncremental() {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int backupPort = PortAuthority.allocatePort();
        ServerInterface server = this.startServer(this.serverPath, backupPort);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
        backup.full(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getDbRepresentation());
        this.shutdownServer(server);
        DbRepresentation furtherRepresentation = this.addMoreData(this.serverPath);
        server = this.startServer(this.serverPath, backupPort);
        backup.incremental(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getDbRepresentation());
        this.shutdownServer(server);
    }

    @Test
    public void makeSureNoLogFileRemains() {
        this.createInitialDataSet(this.serverPath);
        int backupPort = PortAuthority.allocatePort();
        ServerInterface server = this.startServer(this.serverPath, backupPort);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
        backup.full(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertFalse((boolean)BackupIT.checkLogFileExistence(this.backupPath.getPath()));
        backup.incremental(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertFalse((boolean)BackupIT.checkLogFileExistence(this.backupPath.getPath()));
        this.shutdownServer(server);
        this.addMoreData(this.serverPath);
        server = this.startServer(this.serverPath, backupPort);
        backup.incremental(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertFalse((boolean)BackupIT.checkLogFileExistence(this.backupPath.getPath()));
        this.shutdownServer(server);
    }

    @Test
    public void makeSureStoreIdIsEnforced() {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int backupPort = PortAuthority.allocatePort();
        ServerInterface server = this.startServer(this.serverPath, backupPort);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
        backup.full(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getDbRepresentation());
        this.shutdownServer(server);
        this.createInitialDataSet(this.otherServerPath);
        this.addMoreData(this.otherServerPath);
        server = this.startServer(this.otherServerPath, backupPort);
        try {
            backup.incremental(this.backupPath.getPath());
            Assert.fail((String)"Shouldn't work");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(MismatchingStoreIdException.class));
        }
        this.shutdownServer(server);
        DbRepresentation furtherRepresentation = this.addMoreData(this.serverPath);
        server = this.startServer(this.serverPath, backupPort);
        backup.incremental(this.backupPath.getPath());
        Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getDbRepresentation());
        this.shutdownServer(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleIncrementals() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = null;
        try {
            Index index;
            db = this.getEmbeddedTestDataBaseService(backupPort);
            try (Transaction tx = db.beginTx();){
                index = db.index().forNodes("yo");
                index.add((PropertyContainer)db.createNode(), "justTo", (Object)"commitATx");
                db.createNode();
                tx.success();
            }
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            backup.full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
            long lastCommittedTx = this.getLastCommittedTx(this.backupPath.getPath(), pageCache);
            for (int i = 0; i < 5; ++i) {
                try (Transaction tx = db.beginTx();){
                    Node node = db.createNode();
                    index.add((PropertyContainer)node, "key", (Object)("value" + i));
                    tx.success();
                }
                backup = backup.incremental(this.backupPath.getPath());
                Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
                Assert.assertEquals((long)(lastCommittedTx + (long)i + 1L), (long)this.getLastCommittedTx(this.backupPath.getPath(), pageCache));
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupIndexWithNoCommits() {
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = null;
        try {
            db = this.getEmbeddedTestDataBaseService(backupPort);
            try (Transaction transaction = db.beginTx();){
                db.index().forNodes("created-no-commits");
                transaction.success();
            }
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            backup.full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            Assert.assertTrue((boolean)backup.isConsistent());
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    private long getLastCommittedTx(String path, PageCache pageCache) throws IOException {
        File neoStore = new File(path, "neostore");
        return MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupEmptyIndex() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        String key = "name";
        String value = "Neo";
        GraphDatabaseService db = this.getEmbeddedTestDataBaseService(backupPort);
        try {
            Node node;
            Index index;
            try (Transaction tx = db.beginTx();){
                index = db.index().forNodes(key);
                node = db.createNode();
                node.setProperty(key, (Object)value);
                tx.success();
            }
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort).full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)db), (Object)this.getDbRepresentation());
            FileUtils.deleteDirectory((File)new File(this.backupPath.getPath()));
            backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort).full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)db), (Object)this.getDbRepresentation());
            try (Transaction tx = db.beginTx();){
                index.add((PropertyContainer)node, key, (Object)value);
                tx.success();
            }
            FileUtils.deleteDirectory((File)new File(this.backupPath.getPath()));
            backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort).full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)db), (Object)this.getDbRepresentation());
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupMultipleSchemaIndexes() throws InterruptedException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        AtomicBoolean end = new AtomicBoolean();
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = this.getEmbeddedTestDataBaseService(backupPort);
        try {
            int numberOfIndexedLabels = 10;
            List<Label> indexedLabels = this.createIndexes(db, numberOfIndexedLabels);
            executorService.submit(() -> {
                while (!end.get()) {
                    Transaction tx = db.beginTx();
                    Throwable throwable = null;
                    try {
                        db.createNode(new Label[]{(Label)indexedLabels.get(this.random.nextInt(numberOfIndexedLabels))}).setProperty("prop", (Object)this.random.nextValue());
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
            });
            executorService.shutdown();
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort).full(this.backupPath.getPath());
            Assert.assertTrue((String)"Should be consistent", (boolean)backup.isConsistent());
            end.set(true);
            executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        finally {
            db.shutdown();
        }
    }

    private List<Label> createIndexes(GraphDatabaseService db, int indexCount) {
        ArrayList<Label> indexedLabels = new ArrayList<Label>(indexCount);
        for (int i = 0; i < indexCount; ++i) {
            try (Transaction tx = db.beginTx();){
                Label label = Label.label((String)("label" + i));
                indexedLabels.add(label);
                db.schema().indexFor(label).on("prop").create();
                tx.success();
                continue;
            }
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        return indexedLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRetainFileLocksAfterFullBackupOnLiveDatabase() {
        int backupPort = PortAuthority.allocatePort();
        File sourcePath = this.testDir.directory("serverdb-lock");
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(sourcePath).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + backupPort).setConfig(GraphDatabaseSettings.record_format, this.recordFormatName).newGraphDatabase();
        try {
            BackupIT.assertStoreIsLocked(sourcePath);
            OnlineBackup.from((String)"127.0.0.1", (int)backupPort).full(this.backupPath.getPath());
            BackupIT.assertStoreIsLocked(sourcePath);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIncrementallyBackupDenseNodes() {
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = this.startGraphDatabase(this.serverPath, true, backupPort);
        try {
            this.createInitialDataset(db);
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            backup.full(this.backupPath.getPath());
            DbRepresentation representation = this.addLotsOfData(db);
            backup.incremental(this.backupPath.getPath());
            Assert.assertEquals((Object)representation, (Object)this.getDbRepresentation());
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLeaveIdFilesAfterBackup() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = this.startGraphDatabase(this.serverPath, true, backupPort);
        try {
            this.createInitialDataset(db);
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            backup.full(this.backupPath.getPath());
            this.ensureStoresHaveIdFiles(this.backupPath);
            DbRepresentation representation = this.addLotsOfData(db);
            backup.incremental(this.backupPath.getPath());
            Assert.assertEquals((Object)representation, (Object)this.getDbRepresentation());
            this.ensureStoresHaveIdFiles(this.backupPath);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupDatabaseWithCustomTransactionLogsLocation() throws IOException {
        int backupPort = PortAuthority.allocatePort();
        GraphDatabaseService db = this.startGraphDatabase(this.serverPath, true, backupPort, "customLogLocation");
        try {
            this.createInitialDataset(db);
            OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)backupPort);
            String backupStore = this.backupPath.getPath();
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)new File(backupStore), (FileSystemAbstraction)this.fileSystemRule.get()).build();
            backup.full(backupStore);
            Assert.assertThat((Object)logFiles.logFiles(), (Matcher)Matchers.arrayWithSize((int)1));
            DbRepresentation representation = this.addLotsOfData(db);
            backup.incremental(backupStore);
            Assert.assertThat((Object)logFiles.logFiles(), (Matcher)Matchers.arrayWithSize((int)1));
            Assert.assertEquals((Object)representation, (Object)this.getDbRepresentation());
        }
        finally {
            db.shutdown();
        }
    }

    private void ensureStoresHaveIdFiles(File path) throws IOException {
        for (StoreFile file : StoreFile.values()) {
            if (!file.isRecordStore()) continue;
            File idFile = new File(path, file.fileName(StoreFileType.ID));
            Assert.assertTrue((String)("Missing id file " + idFile), (boolean)idFile.exists());
            Assert.assertTrue((String)("Id file " + idFile + " had 0 highId"), (IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fileSystemRule.get(), (File)idFile) > 0L ? 1 : 0) != 0);
        }
    }

    private DbRepresentation addLotsOfData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            int threshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
            for (int i = 0; i < threshold * 2; ++i) {
                node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
        }
        return DbRepresentation.of((GraphDatabaseService)db);
    }

    private static void assertStoreIsLocked(File path) {
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabase(path).shutdown();
            Assert.fail((String)"Could start up database in same process, store not locked");
        }
        catch (RuntimeException ex) {
            Assert.assertThat((Object)ex.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
    }

    private static boolean checkLogFileExistence(String directory) {
        return ((File)Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (String)directory).get(GraphDatabaseSettings.store_internal_log_path)).exists();
    }

    private long lastTxChecksumOf(File storeDir, PageCache pageCache) throws IOException {
        File neoStore = new File(storeDir, "neostore");
        return MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
    }

    private ServerInterface startServer(File path, int backupPort) {
        EmbeddedServer server = new EmbeddedServer(path, "127.0.0.1:" + backupPort);
        server.awaitStarted();
        this.servers.add(server);
        return server;
    }

    private void shutdownServer(ServerInterface server) {
        server.shutdown();
        this.servers.remove(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbRepresentation addMoreData(File path) {
        DbRepresentation representation;
        GraphDatabaseService db = this.startGraphDatabase(path, false, null);
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("backup", (Object)"Is great");
            db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"LOVES"));
            tx.success();
        }
        finally {
            representation = DbRepresentation.of((GraphDatabaseService)db);
            db.shutdown();
        }
        return representation;
    }

    private GraphDatabaseService startGraphDatabase(File storeDir, boolean withOnlineBackup, Integer backupPort) {
        return this.startGraphDatabase(storeDir, withOnlineBackup, backupPort, "");
    }

    private GraphDatabaseService startGraphDatabase(File storeDir, boolean withOnlineBackup, Integer backupPort, String logLocation) {
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory(){

            protected GraphDatabaseService newDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                Function<PlatformModule, EditionModule> factory = platformModule -> new CommunityEditionModule((PlatformModule)platformModule){

                    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
                        return new TransactionHeaderInformationFactory.WithRandomBytes(){

                            protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
                                return new TransactionHeaderInformation(1, 2, additionalHeader);
                            }
                        };
                    }
                };
                return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, factory).newFacade(storeDir, config, dependencies);
            }
        };
        GraphDatabaseBuilder graphDatabaseBuilder = dbFactory.newEmbeddedDatabaseBuilder(storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, String.valueOf(withOnlineBackup)).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").setConfig(GraphDatabaseSettings.record_format, this.recordFormatName).setConfig(GraphDatabaseSettings.logical_logs_location, logLocation);
        if (backupPort != null) {
            graphDatabaseBuilder.setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + backupPort);
        }
        return graphDatabaseBuilder.newGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbRepresentation createInitialDataSet(File path) {
        GraphDatabaseService db = this.startGraphDatabase(path, false, null);
        try {
            this.createInitialDataset(db);
            DbRepresentation dbRepresentation = DbRepresentation.of((GraphDatabaseService)db);
            return dbRepresentation;
        }
        finally {
            db.shutdown();
        }
    }

    private void createInitialDataset(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{Label.label((String)"Me")});
            node.setProperty("myKey", (Object)"myValue");
            Index nodeIndex = db.index().forNodes("db-index");
            nodeIndex.add((PropertyContainer)node, "myKey", (Object)"myValue");
            db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
    }

    private GraphDatabaseService getEmbeddedTestDataBaseService(int backupPort) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.serverPath).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + backupPort).setConfig(GraphDatabaseSettings.record_format, this.recordFormatName).newGraphDatabase();
    }

    private DbRepresentation getDbRepresentation() {
        return DbRepresentation.of((File)this.backupPath, (Config)Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false"));
    }
}

