/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;

public class TestConfiguration {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private static final File SOURCE_DIR = new File("target/db");
    private static final String BACKUP_DIR = "target/full-backup";
    private static final String HOST_ADDRESS = "127.0.0.1";

    @Before
    public void before() throws Exception {
        FileUtils.deleteDirectory((File)SOURCE_DIR);
        FileUtils.deleteDirectory((File)new File(BACKUP_DIR));
    }

    @Test
    public void testOnByDefault() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(SOURCE_DIR);
        OnlineBackup.from((String)HOST_ADDRESS).full(BACKUP_DIR);
        db.shutdown();
    }

    @Test
    public void testOffByConfig() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS).full(BACKUP_DIR);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        db.shutdown();
    }

    @Test
    public void testEnableDefaultsInConfig() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "true").newGraphDatabase();
        OnlineBackup.from((String)HOST_ADDRESS).full(BACKUP_DIR);
        db.shutdown();
    }

    @Test
    public void testEnableCustomPortInConfig() throws Exception {
        String customPort = "12345";
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, ":" + customPort).newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS).full(BACKUP_DIR);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OnlineBackup.from((String)HOST_ADDRESS, (int)Integer.parseInt(customPort)).full(BACKUP_DIR);
        db.shutdown();
    }
}

