/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

public class BackupLabelIndexIT {
    private static final TestLabels LABEL = TestLabels.LABEL_ONE;
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    private File sourceDir;
    private File backupDir;
    private GraphDatabaseService db;
    private GraphDatabaseService backupDb;

    @Before
    public void setupDirectoroes() {
        this.sourceDir = this.directory.absolutePath();
        this.backupDir = this.directory.directory("backup");
    }

    @After
    public void shutdownDbs() {
        if (this.backupDb != null) {
            this.backupDb.shutdown();
        }
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void shouldHandleBackingUpFromSourceThatSwitchesLabelIndexProviderAllIndexConfigMatching() throws Exception {
        Object[] types = GraphDatabaseSettings.LabelIndex.values();
        HashSet<Node> expectedNodes = new HashSet<Node>();
        for (int i = 0; i < 5; ++i) {
            GraphDatabaseSettings.LabelIndex index = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            this.db = BackupLabelIndexIT.db(this.sourceDir, index, true);
            Node node = BackupLabelIndexIT.createNode(this.db);
            expectedNodes.add(node);
            BackupLabelIndexIT.backupTo(index, this.backupDir);
            this.backupDb = BackupLabelIndexIT.db(this.backupDir, index, false);
            BackupLabelIndexIT.assertNodes(this.backupDb, expectedNodes);
            this.shutdownDbs();
        }
    }

    @Test
    public void shouldHandleBackingUpFromSourceThatSwitchesLabelIndexProviderBackupHasDifferentIndex() throws Exception {
        Object[] types = GraphDatabaseSettings.LabelIndex.values();
        HashSet<Node> expectedNodes = new HashSet<Node>();
        for (int i = 0; i < 5; ++i) {
            GraphDatabaseSettings.LabelIndex index = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            this.db = BackupLabelIndexIT.db(this.sourceDir, index, true);
            Node node = BackupLabelIndexIT.createNode(this.db);
            expectedNodes.add(node);
            GraphDatabaseSettings.LabelIndex indexForBackup = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            BackupLabelIndexIT.backupTo(indexForBackup, this.backupDir);
            this.backupDb = BackupLabelIndexIT.db(this.backupDir, indexForBackup, false);
            BackupLabelIndexIT.assertNodes(this.backupDb, expectedNodes);
            this.shutdownDbs();
        }
    }

    @Test
    public void shouldHandleBackingUpFromSourceThatSwitchesLabelIndexProviderBackupHasDifferentIndexAlsoInternally() throws Exception {
        Object[] types = GraphDatabaseSettings.LabelIndex.values();
        HashSet<Node> expectedNodes = new HashSet<Node>();
        for (int i = 0; i < 5; ++i) {
            GraphDatabaseSettings.LabelIndex index = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            this.db = BackupLabelIndexIT.db(this.sourceDir, index, true);
            Node node = BackupLabelIndexIT.createNode(this.db);
            expectedNodes.add(node);
            GraphDatabaseSettings.LabelIndex backupIndex = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            BackupLabelIndexIT.backupTo(backupIndex, this.backupDir);
            GraphDatabaseSettings.LabelIndex backupDbIndex = (GraphDatabaseSettings.LabelIndex)this.random.among(types);
            this.backupDb = BackupLabelIndexIT.db(this.backupDir, backupDbIndex, false);
            BackupLabelIndexIT.assertNodes(this.backupDb, expectedNodes);
            this.shutdownDbs();
        }
    }

    private static void backupTo(GraphDatabaseSettings.LabelIndex index, File toDir) {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.label_index.name(), index.name()}));
        new BackupService(DefaultFileSystemAbstraction::new, (LogProvider)NullLogProvider.getInstance(), new Monitors()).doIncrementalBackupOrFallbackToFull("localhost", 6362, toDir, ConsistencyCheck.FULL, config, BackupClient.BIG_READ_TIMEOUT, false);
    }

    private static void assertNodes(GraphDatabaseService db, Set<Node> expectedNodes) {
        try (Transaction tx = db.beginTx();
             ResourceIterator found = db.findNodes((Label)LABEL);){
            Assert.assertEquals(expectedNodes, (Object)Iterators.asSet((Iterator)found));
            tx.success();
        }
    }

    private static Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{LABEL});
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private static GraphDatabaseService db(File storeDir, GraphDatabaseSettings.LabelIndex index, boolean backupEnabled) {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.label_index, index.name());
        if (backupEnabled) {
            builder.setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "localhost:6362");
        }
        return builder.newGraphDatabase();
    }
}

