/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.OnlineBackupCommandSection;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.OnlineBackupCommand;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.consistency.ConsistencyCheckService;

public class OnlineBackupCommandProvider
extends AdminCommand.Provider {
    public OnlineBackupCommandProvider() {
        super("backup", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return OnlineBackupCommand.arguments();
    }

    @Nonnull
    public String description() {
        return "Perform an online backup from a running Neo4j enterprise server. Neo4j's backup service must have been configured on the server beforehand. See https://neo4j.com/docs/operations-manual/current/backup/ for more details.";
    }

    @Nonnull
    public String summary() {
        return "Perform an online backup from a running Neo4j enterprise server.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return OnlineBackupCommandSection.instance();
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new OnlineBackupCommand(new BackupService(outsideWorld.errorStream()), homeDir, configDir, new ConsistencyCheckService(), outsideWorld);
    }
}

