/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.neo4j.backup.ConsistencyCheckFailedException;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

interface ConsistencyCheck {
    public static final ConsistencyCheck NONE = new ConsistencyCheck(){

        @Override
        public String name() {
            return "none";
        }

        @Override
        public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckFailedException {
            return true;
        }
    };
    public static final ConsistencyCheck FULL = new ConsistencyCheck(){

        @Override
        public String name() {
            return "full";
        }

        @Override
        public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckFailedException {
            try {
                return new ConsistencyCheckService().runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose).isSuccessful();
            }
            catch (ConsistencyCheckIncompleteException e) {
                throw new ConsistencyCheckFailedException(e);
            }
        }
    };

    public String name();

    public boolean runFull(File var1, Config var2, ProgressMonitorFactory var3, LogProvider var4, FileSystemAbstraction var5, PageCache var6, boolean var7) throws ConsistencyCheckFailedException;

    public String toString();

    public static ConsistencyCheck fromString(String name) {
        for (ConsistencyCheck consistencyCheck : new ConsistencyCheck[]{NONE, FULL}) {
            if (!consistencyCheck.name().equalsIgnoreCase(name)) continue;
            return consistencyCheck;
        }
        throw new IllegalArgumentException("Unknown consistency check name: " + name + ". Supported values: NONE, FULL");
    }

    public static ConsistencyCheck full(final File reportDir, final ConsistencyCheckService consistencyCheckService) {
        return new ConsistencyCheck(){

            @Override
            public String name() {
                return "full";
            }

            @Override
            public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckFailedException {
                try {
                    return consistencyCheckService.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir).isSuccessful();
                }
                catch (ConsistencyCheckIncompleteException e) {
                    throw new ConsistencyCheckFailedException(e);
                }
            }
        };
    }
}

