/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.function.Supplier;
import org.neo4j.backup.StoreCopyResponsePacker;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

class BackupImpl
implements TheBackupInterface {
    static final String FULL_BACKUP_CHECKPOINT_TRIGGER = "full backup";
    private final StoreCopyServer storeCopyServer;
    private final ResponsePacker incrementalResponsePacker;
    private final LogicalTransactionStore logicalTransactionStore;
    private final Supplier<StoreId> storeId;
    private final TransactionIdStore transactionIdStore;
    private final LogFileInformation logFileInformation;
    private final Logger logger;

    public BackupImpl(StoreCopyServer storeCopyServer, Monitors monitors, LogicalTransactionStore logicalTransactionStore, TransactionIdStore transactionIdStore, LogFileInformation logFileInformation, Supplier<StoreId> storeId, LogProvider logProvider) {
        this.storeCopyServer = storeCopyServer;
        this.logicalTransactionStore = logicalTransactionStore;
        this.transactionIdStore = transactionIdStore;
        this.logFileInformation = logFileInformation;
        this.storeId = storeId;
        this.logger = logProvider.getLog(this.getClass()).infoLogger();
        this.incrementalResponsePacker = new ResponsePacker(logicalTransactionStore, transactionIdStore, storeId);
    }

    /*
     * Loose catch block
     */
    @Override
    public Response<Void> fullBackup(StoreWriter writer, boolean forensics) {
        try {
            try (StoreWriter storeWriter = writer;){
                this.logger.log("Full backup started...");
                RequestContext copyStartContext = this.storeCopyServer.flushStoresAndStreamStoreFiles(FULL_BACKUP_CHECKPOINT_TRIGGER, storeWriter, forensics);
                StoreCopyResponsePacker responsePacker = new StoreCopyResponsePacker(this.logicalTransactionStore, this.transactionIdStore, this.logFileInformation, this.storeId, copyStartContext.lastAppliedTransaction() + 1L, this.storeCopyServer.monitor());
                long optionalTransactionId = copyStartContext.lastAppliedTransaction();
                Response response = responsePacker.packTransactionStreamResponse(RequestContext.anonymous((long)optionalTransactionId), null);
                return response;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.logger.log("Full backup finished.");
        }
    }

    @Override
    public Response<Void> incrementalBackup(RequestContext context) {
        try {
            this.logger.log("Incremental backup started...");
            Response response = this.incrementalResponsePacker.packTransactionStreamResponse(context, null);
            return response;
        }
        finally {
            this.logger.log("Incremental backup finished.");
        }
    }
}

