/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.OnlineBackupCommand;
import org.neo4j.backup.OnlineBackupCommandProvider;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;

public class OnlineBackupCommandTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private BackupService backupService = (BackupService)Mockito.mock(BackupService.class);
    private OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
    private Path configDir;
    private ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
    private ConsistencyCheckService.Result ccResult = (ConsistencyCheckService.Result)Mockito.mock(ConsistencyCheckService.Result.class);
    private PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
    private PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
    private FileSystemAbstraction mockFs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)new DefaultFileSystemAbstraction());
        Mockito.when((Object)this.outsideWorld.errorStream()).thenReturn((Object)this.err);
        Mockito.when((Object)this.outsideWorld.outStream()).thenReturn((Object)this.out);
        Mockito.when((Object)this.ccResult.isSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)this.consistencyCheckService.runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.any())).thenReturn((Object)this.ccResult);
        this.configDir = this.testDirectory.directory("config-dir").toPath();
    }

    @Test
    public void shouldNotRequestForensics() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute(OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldDefaultFromToDefaultBackupAddress() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute(OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.eq((Object)"localhost"), Matchers.eq((int)6362), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultPortAndPassHost() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.eq((Object)"foo.bar.server"), Matchers.eq((int)6362), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldAcceptAHostWithATrailingColon() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.eq((Object)"foo.bar.server"), Matchers.eq((int)6362), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultHostAndPassPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=:1234", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.eq((Object)"localhost"), Matchers.eq((int)1234), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassHostAndPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:1234", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.eq((Object)"foo.bar.server"), Matchers.eq((int)1234), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassDestination() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Path dest = Paths.get("/", new String[0]);
        this.execute(OnlineBackupCommandTest.backupDir(OnlineBackupCommandTest.path(dest.toString())), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.eq((Object)new File(OnlineBackupCommandTest.path(dest.resolve("mybackup").toString()))), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void nonExistingBackupDirThrows() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        String path = OnlineBackupCommandTest.path("/Idontexist/sasdfasdfa");
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Directory '" + path + "' does not exist.");
        this.execute(OnlineBackupCommandTest.backupDir(path), "--name=mybackup");
    }

    @Test
    public void shouldTreatBackupDirArgumentAsMandatory() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("Missing argument 'backup-dir'");
        this.execute(new String[0]);
    }

    @Test
    public void shouldTreatNameArgumentAsMandatory() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("Missing argument 'name'");
        this.execute(OnlineBackupCommandTest.backupDir());
    }

    @Test
    public void shouldNotAskForConsistencyCheckIfNotSpecified() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--check-consistency=false", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.consistencyCheckService});
    }

    @Test
    public void shouldAskForConsistencyCheckIfSpecified() throws Exception {
        this.execute("--check-consistency=true", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)new File(".").getCanonicalFile()));
    }

    @Test
    public void shouldAskForConsistencyCheckIfSpecifiedIncremental() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Assert.assertTrue((boolean)new File(dir, "afile").createNewFile());
        this.execute("--check-consistency=true", OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)new File(".").getCanonicalFile()));
    }

    @Test
    public void shouldNotAskForConsistencyCheckIfSpecifiedIncremental() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Assert.assertTrue((boolean)new File(dir, "afile").createNewFile());
        this.execute("--check-consistency=false", OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.consistencyCheckService});
    }

    @Test
    public void failedCCIsReported() throws Exception {
        Path path = Paths.get("/foo/bar", new String[0]);
        Mockito.when((Object)this.consistencyCheckService.runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)new File(".").getCanonicalFile()))).thenReturn((Object)ConsistencyCheckService.Result.failure((File)path.toFile()));
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Inconsistencies found. See '" + path + "' for details.");
        this.execute("--check-consistency=true", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
    }

    @Test
    public void shouldDoFullIfDirectoryDoesNotExist() throws Exception {
        File dir = this.testDirectory.directory("ccFull");
        Assert.assertTrue((boolean)dir.delete());
        this.execute(OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Doing full backup...");
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Backup complete.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
    }

    @Test
    public void shouldDoFullIfDirectoryEmpty() throws Exception {
        File dir = this.testDirectory.directory("ccFull");
        this.execute(OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Doing full backup...");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
    }

    @Test
    public void shouldDoIncrementalIfDirectoryNonEmpty() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Assert.assertTrue((boolean)new File(dir, "afile").createNewFile());
        this.execute(OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Destination is not empty, doing incremental backup...");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
    }

    @Test
    public void shouldFallbackToFullIfIncrementalFails() throws Exception {
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.mockFs);
        File dir = this.testDirectory.directory("ccInc");
        Mockito.when((Object)this.mockFs.isDirectory((File)Matchers.eq((Object)dir.getParentFile()))).thenReturn((Object)true);
        Mockito.when((Object)this.mockFs.listFiles((File)Matchers.eq((Object)dir))).thenReturn((Object)new File[]{dir});
        Mockito.when((Object)this.backupService.doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException("nah-ah")});
        this.execute("--cc-report-dir=" + dir.getParent(), OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Destination is not empty, doing incremental backup...");
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdErrLine("Incremental backup failed: nah-ah");
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdErrLine("Old backup renamed to 'ccInc.err.1'.");
        ((FileSystemAbstraction)Mockito.verify((Object)this.mockFs)).renameFile((File)Matchers.eq((Object)dir), (File)Matchers.eq((Object)this.testDirectory.directory("ccInc.err.1")), new CopyOption[0]);
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Doing full backup...");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
    }

    @Test
    public void failToRenameIsReported() throws Exception {
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.mockFs);
        File dir = this.testDirectory.directory("ccInc");
        Mockito.when((Object)this.mockFs.isDirectory((File)Matchers.eq((Object)dir.getParentFile()))).thenReturn((Object)true);
        Mockito.when((Object)this.mockFs.listFiles((File)Matchers.eq((Object)dir))).thenReturn((Object)new File[]{dir});
        Mockito.when((Object)this.backupService.doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException("nah-ah")});
        ((FileSystemAbstraction)Mockito.doThrow((Throwable)new IOException("kaboom")).when((Object)this.mockFs)).renameFile((File)Matchers.any(), (File)Matchers.any(), new CopyOption[0]);
        this.expected.expectMessage("Failed to move old backup out of the way: kaboom");
        this.expected.expect(CommandFailed.class);
        this.execute("--cc-report-dir=" + dir.getParent(), OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
    }

    @Test
    public void shouldNotFallbackToFullIfSpecified() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Assert.assertTrue((boolean)new File(dir, "afile").createNewFile());
        Mockito.when((Object)this.backupService.doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException("nah-ah")});
        this.expected.expectMessage("Backup failed: nah-ah");
        this.expected.expect(CommandFailed.class);
        this.execute("--fallback-to-full=false", OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
    }

    @Test
    public void renamingOldBackupIncrements() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.mockFs);
        Mockito.when((Object)this.mockFs.isDirectory((File)Matchers.eq((Object)dir.getParentFile()))).thenReturn((Object)true);
        Mockito.when((Object)this.mockFs.listFiles((File)Matchers.eq((Object)dir))).thenReturn((Object)new File[]{dir});
        for (int i = 1; i < 50; ++i) {
            Mockito.when((Object)this.mockFs.fileExists((File)Matchers.eq((Object)new File(dir.getParentFile(), "ccInc.err." + i)))).thenReturn((Object)true);
        }
        Mockito.when((Object)this.backupService.doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException("nah-ah")});
        this.execute("--cc-report-dir=" + dir.getParent(), OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
        ((BackupService)Mockito.verify((Object)this.backupService)).doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Destination is not empty, doing incremental backup...");
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdErrLine("Incremental backup failed: nah-ah");
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdErrLine("Old backup renamed to 'ccInc.err.50'.");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((OutsideWorld)Mockito.verify((Object)this.outsideWorld)).stdOutLine("Doing full backup...");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.backupService});
    }

    @Test
    public void renamingOldBackupIncrementsOnlySoFar() throws Exception {
        File dir = this.testDirectory.directory("ccInc");
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.mockFs);
        Mockito.when((Object)this.mockFs.isDirectory((File)Matchers.eq((Object)dir.getParentFile()))).thenReturn((Object)true);
        Mockito.when((Object)this.mockFs.listFiles((File)Matchers.eq((Object)dir))).thenReturn((Object)new File[]{dir});
        for (int i = 1; i < 1000; ++i) {
            Mockito.when((Object)this.mockFs.fileExists((File)Matchers.eq((Object)new File(dir.getParentFile(), "ccInc.err." + i)))).thenReturn((Object)true);
        }
        Mockito.when((Object)this.backupService.doIncrementalBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), Matchers.anyLong(), (Config)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException("nah-ah")});
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("ailed to move old backup out of the way: too many old backups.");
        this.execute("--cc-report-dir=" + dir.getParent(), OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
    }

    @Test
    public void shouldSpecifyReportDirIfSpecified() throws Exception {
        File reportDir = this.testDirectory.directory("ccreport");
        Mockito.when((Object)this.consistencyCheckService.runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.any())).thenReturn((Object)ConsistencyCheckService.Result.success(null));
        this.execute("--check-consistency", OnlineBackupCommandTest.backupDir(), "--name=mybackup", "--cc-report-dir=" + reportDir);
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)reportDir.getCanonicalFile()));
    }

    @Test
    public void fullFailureIsReported() throws Exception {
        File dir = this.testDirectory.directory("ccFull");
        Mockito.when((Object)this.backupService.doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("nope")});
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Backup failed: nope");
        this.execute(OnlineBackupCommandTest.backupDir(dir.getParent()), "--name=" + dir.getName());
    }

    @Test
    public void reportDirMustBeAPath() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("cc-report-dir must be a path");
        this.execute("--check-consistency", OnlineBackupCommandTest.backupDir(), "--name=mybackup", "--cc-report-dir");
    }

    @Test
    public void reportDirMustExist() throws Exception {
        String path = OnlineBackupCommandTest.path("/aalivnmoimzlckmvPDK");
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Directory '" + path + "' does not exist.");
        this.execute("--check-consistency", OnlineBackupCommandTest.backupDir(), "--name=mybackup", "--cc-report-dir=" + path);
    }

    @Test
    public void shouldReadStandardConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Files.write(this.configDir.resolve("neo4j.conf"), Collections.singletonList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute(OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldAugmentConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Path extraConf = this.testDirectory.directory("someOtherDir").toPath().resolve("extra.conf");
        Files.write(extraConf, Collections.singletonList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--additional-config=" + extraConf, OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldDefaultTimeoutToTwentyMinutes() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute(OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.MINUTES.toMillis(20L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldInterpretAUnitlessTimeoutAsSeconds() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.SECONDS.toMillis(10L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldParseATimeoutWithUnits() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10h", OnlineBackupCommandTest.backupDir(), "--name=mybackup");
        ((BackupService)Mockito.verify((Object)this.backupService)).doFullBackup((String)Matchers.any(), Matchers.anyInt(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.HOURS.toMillis(10L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new OnlineBackupCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin backup --backup-dir=<backup-path> --name=<graph.db-backup>%n                          [--from=<address>] [--fallback-to-full[=<true|false>]]%n                          [--check-consistency[=<true|false>]]%n                          [--cc-report-dir=<directory>]%n                          [--additional-config=<config-file-path>]%n                          [--timeout=<timeout>]%n%nPerform an online backup from a running Neo4j enterprise server. Neo4j's backup%nservice must have been configured on the server beforehand. See%nhttps://neo4j.com/docs/operations-manual/current/backup/ for more details.%n%noptions:%n  --backup-dir=<backup-path>               Directory to place backup in.%n  --name=<graph.db-backup>                 Name of backup. If a backup with this%n                                           name already exists an incremental%n                                           backup will be attempted.%n  --from=<address>                         Host and port of Neo4j.%n                                           [default:localhost:6362]%n  --fallback-to-full=<true|false>          If an incremental backup fails backup%n                                           will move the old backup to%n                                           <name>.err.<N> and fallback to a full%n                                           backup instead. [default:true]%n  --check-consistency=<true|false>         If a consistency check should be%n                                           made. [default:true]%n  --cc-report-dir=<directory>              Directory where consistency report%n                                           will be written. [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in.%n                                           [default:]%n  --timeout=<timeout>                      Timeout in the form <time>[ms|s|m|h],%n                                           where the default unit is seconds.%n                                           [default:20m]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void execute(String ... args) throws IncorrectUsage, CommandFailed {
        new OnlineBackupCommand(this.backupService, Paths.get("/some/path", new String[0]), this.configDir, this.consistencyCheckService, this.outsideWorld).execute(args);
    }

    static String path(String path) {
        return Paths.get(path, new String[0]).toFile().getAbsolutePath();
    }

    static String backupDir() {
        return OnlineBackupCommandTest.backupDir("/");
    }

    static String backupDir(String path) {
        return "--backup-dir=" + OnlineBackupCommandTest.path(path);
    }
}

