/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.TestDirectory;

public class BackupToolIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory(this.getClass());
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass()).startLazily();
    private DefaultFileSystemAbstraction fs;
    private PageCache pageCache;
    private Path backupDir;
    private BackupTool backupTool;

    @Before
    public void setUp() throws Exception {
        this.backupDir = this.testDirectory.directory("backups/graph.db").toPath();
        this.fs = new DefaultFileSystemAbstraction();
        this.pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs);
        this.backupTool = new BackupTool(new BackupService(), (PrintStream)Mockito.mock(PrintStream.class));
    }

    @After
    public void tearDown() throws Exception {
        this.pageCache.close();
        this.fs.close();
    }

    @Test
    public void oldIncompatibleBackupsThrows() throws Exception {
        this.prepareNeoStoreFile(StandardV2_3.STORE_VERSION);
        this.dbRule.getGraphDatabaseAPI();
        this.expected.expect(BackupTool.ToolFailureException.class);
        this.expected.expectMessage("Failed to perform backup because existing backup is from a different version.");
        this.backupTool.executeBackup(new HostnamePort("localhost", 6362), this.backupDir.toFile(), ConsistencyCheck.NONE, Config.defaults(), 1200000L, false);
    }

    private void prepareNeoStoreFile(String storeVersion) throws Exception {
        File neoStoreFile = this.createNeoStoreFile();
        long value = MetaDataStore.versionStringToLong((String)storeVersion);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)value);
    }

    private File createNeoStoreFile() throws Exception {
        this.fs.mkdirs(this.backupDir.toFile());
        File neoStoreFile = new File(this.backupDir.toFile(), "neostore");
        this.fs.create(neoStoreFile).close();
        return neoStoreFile;
    }
}

