/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.function.Factory;

class BufferReusingChunkingChannelBuffer
extends ChunkingChannelBuffer {
    private static final Factory<ChannelBuffer> DEFAULT_CHANNEL_BUFFER_FACTORY = new Factory<ChannelBuffer>(){

        public ChannelBuffer newInstance() {
            return ChannelBuffers.dynamicBuffer();
        }
    };
    private final Factory<ChannelBuffer> bufferFactory;
    private final Queue<ChannelBuffer> freeBuffers = new LinkedBlockingQueue<ChannelBuffer>(5);

    BufferReusingChunkingChannelBuffer(ChannelBuffer initialBuffer, Channel channel, int capacity, byte internalProtocolVersion, byte applicationProtocolVersion) {
        this(initialBuffer, DEFAULT_CHANNEL_BUFFER_FACTORY, channel, capacity, internalProtocolVersion, applicationProtocolVersion);
    }

    BufferReusingChunkingChannelBuffer(ChannelBuffer initialBuffer, Factory<ChannelBuffer> bufferFactory, Channel channel, int capacity, byte internalProtocolVersion, byte applicationProtocolVersion) {
        super(initialBuffer, channel, capacity, internalProtocolVersion, applicationProtocolVersion);
        this.bufferFactory = bufferFactory;
    }

    protected ChannelBuffer newChannelBuffer() {
        ChannelBuffer buffer = this.freeBuffers.poll();
        return buffer == null ? (ChannelBuffer)this.bufferFactory.newInstance() : buffer;
    }

    protected ChannelFutureListener newChannelFutureListener(final ChannelBuffer buffer) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                buffer.clear();
                BufferReusingChunkingChannelBuffer.this.freeBuffers.offer(buffer);
                BufferReusingChunkingChannelBuffer.super.operationComplete(future);
            }
        };
    }
}

