/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.OnlineBackupCommand;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;

public class OnlineBackupCommandTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private final BackupTool tool = (BackupTool)Mockito.mock(BackupTool.class);
    private Path configDir;
    private ConsistencyCheckService consistencyCheckService;

    @Before
    public void setUp() throws Exception {
        this.configDir = this.testDirectory.directory("config-dir").toPath();
    }

    @Test
    public void shouldNotRequestForensics() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldDefaultFromToDefaultBackupAddress() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("localhost", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultPortAndPassHost() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldAcceptAHostWithATrailingColon() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultHostAndPassPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=:1234", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("localhost", 1234)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassHostAndPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:1234", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 1234)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassDestination() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/some/path/or/other");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.eq((Object)new File("/some/path/or/other")), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldTreatToArgumentAsMandatory() throws CommandFailed {
        try {
            this.execute(new String[0]);
            Assert.fail((String)"exception expected");
        }
        catch (IncorrectUsage incorrectUsage) {
            Assert.assertThat((Object)incorrectUsage.getMessage(), (Matcher)CoreMatchers.containsString((String)"to"));
        }
    }

    @Test
    public void shouldNotAskForConsistencyCheckIfNotSpecified() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--check-consistency=false", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.eq((Object)ConsistencyCheck.NONE), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldAskForConsistencyCheckIfSpecified() throws Exception {
        this.consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Mockito.stub((Object)this.consistencyCheckService.runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), (PageCache)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.any())).toReturn((Object)ConsistencyCheckService.Result.success(null));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConsistencyCheck.class);
        Mockito.stub((Object)this.tool.executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)captor.capture(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean())).toReturn(null);
        this.execute("--check-consistency", "--to=/");
        ((ConsistencyCheck)captor.getValue()).runFull(null, null, null, null, null, null, false);
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), (PageCache)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)new File(".").getCanonicalFile()));
    }

    @Test
    public void shouldSpecifyReportDirIfSpecified() throws Exception {
        this.consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        Mockito.stub((Object)this.consistencyCheckService.runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), (PageCache)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.any())).toReturn((Object)ConsistencyCheckService.Result.success(null));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConsistencyCheck.class);
        Mockito.stub((Object)this.tool.executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)captor.capture(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean())).toReturn(null);
        this.execute("--check-consistency", "--to=/", "--cc-report-dir=" + Paths.get("some", "dir"));
        ((ConsistencyCheck)captor.getValue()).runFull(null, null, null, null, null, null, false);
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)Matchers.any(), (Config)Matchers.any(), (ProgressMonitorFactory)Matchers.any(), (LogProvider)Matchers.any(), (FileSystemAbstraction)Matchers.any(), (PageCache)Matchers.any(), Matchers.anyBoolean(), (File)Matchers.eq((Object)new File("some/dir").getCanonicalFile()));
    }

    @Test
    public void shouldIncludeGraphDatabaseSettings() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).getSettingsClasses(), (Matcher)CoreMatchers.hasItem(GraphDatabaseSettings.class));
    }

    @Test
    public void shouldIncludeConsistencyCheckSettings() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).getSettingsClasses(), (Matcher)CoreMatchers.hasItem(ConsistencyCheckSettings.class));
    }

    @Test
    public void shouldReadStandardConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Files.write(this.configDir.resolve("neo4j.conf"), Arrays.asList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldAugmentConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Path extraConf = this.testDirectory.directory("someOtherDir").toPath().resolve("extra.conf");
        Files.write(extraConf, Arrays.asList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--additional-config=" + extraConf, "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldDefaultTimeoutToTwentyMinutes() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.MINUTES.toMillis(20L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldInterpretAUnitlessTimeoutAsSeconds() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.SECONDS.toMillis(10L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldParseATimeoutWithUnits() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10h", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.HOURS.toMillis(10L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new OnlineBackupCommand.Provider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin backup [--from=<address>] --to=<backup-path>%n                          [--check-consistency[=<true|false>]]%n                          [--cc-report-dir=<directory>]%n                          [--additional-config=<config-file-path>]%n                          [--timeout=<timeout>]%n%nPerform a backup, over the network, from a running Neo4j server into a local%ncopy of the database store (the backup). Neo4j Server must be configured to run%na backup service. See http://neo4j.com/docs/operations-manual/current/backup/%nfor more details.%n%noptions:%n  --from=<address>                         Host and port of Neo4j.%n                                           [default:localhost:6362]%n  --to=<backup-path>                       Directory where the backup will be%n                                           made; if there is already a backup%n                                           present an incremental backup will be%n                                           attempted.%n  --check-consistency=<true|false>         If a consistency check should be%n                                           made. [default:true]%n  --cc-report-dir=<directory>              Directory where consistency report%n                                           will be written. [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in.%n                                           [default:]%n  --timeout=<timeout>                      Timeout in the form <time>[ms|s|m|h],%n                                           where the default unit is seconds.%n                                           [default:20m]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void execute(String ... args) throws IncorrectUsage, CommandFailed {
        new OnlineBackupCommand(this.tool, Paths.get("/some/path", new String[0]), this.configDir, this.consistencyCheckService).execute(args);
    }
}

