/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BufferReusingChunkingChannelBuffer;
import org.neo4j.function.Factory;

public class BufferReusingChunkingChannelBufferTest {
    @Test
    public void newBuffersAreCreatedIfNoFreeBuffersAreAvailable() {
        CountingChannelBufferFactory bufferFactory = new CountingChannelBufferFactory();
        BufferReusingChunkingChannelBuffer buffer = BufferReusingChunkingChannelBufferTest.newBufferReusingChunkingChannelBuffer(10, bufferFactory);
        buffer.writeLong(1L);
        buffer.writeLong(2L);
        buffer.writeLong(3L);
        Assert.assertEquals((long)3L, (long)bufferFactory.instancesCreated);
    }

    @Test
    public void freeBuffersAreReused() throws Exception {
        CountingChannelBufferFactory bufferFactory = new CountingChannelBufferFactory();
        BufferReusingChunkingChannelBuffer buffer = BufferReusingChunkingChannelBufferTest.newBufferReusingChunkingChannelBuffer(10, bufferFactory);
        buffer.writeLong(1L);
        buffer.writeLong(2L);
        ChannelBuffer reusedBuffer1 = BufferReusingChunkingChannelBufferTest.triggerOperationCompleteCallback(buffer);
        ChannelBuffer reusedBuffer2 = BufferReusingChunkingChannelBufferTest.triggerOperationCompleteCallback(buffer);
        buffer.writeLong(3L);
        buffer.writeLong(4L);
        Assert.assertEquals((long)2L, (long)bufferFactory.instancesCreated);
        ((ChannelBuffer)Mockito.verify((Object)reusedBuffer1)).writeLong(3L);
        ((ChannelBuffer)Mockito.verify((Object)reusedBuffer2)).writeLong(4L);
    }

    private static BufferReusingChunkingChannelBuffer newBufferReusingChunkingChannelBuffer(int capacity, CountingChannelBufferFactory bufferFactory) {
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelFuture channelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)channel.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)channel.isBound()).thenReturn((Object)true);
        Mockito.when((Object)channel.write(Matchers.anyObject())).thenReturn((Object)channelFuture);
        return new BufferReusingChunkingChannelBuffer(buffer, (Factory)bufferFactory, channel, capacity, 1, 1);
    }

    private static ChannelBuffer triggerOperationCompleteCallback(BufferReusingChunkingChannelBuffer buffer) throws Exception {
        ChannelBuffer reusedBuffer = (ChannelBuffer)Mockito.spy((Object)ChannelBuffers.dynamicBuffer());
        ChannelFuture channelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)channelFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)channelFuture.isSuccess()).thenReturn((Object)true);
        buffer.newChannelFutureListener(reusedBuffer).operationComplete(channelFuture);
        return reusedBuffer;
    }

    private static class CountingChannelBufferFactory
    implements Factory<ChannelBuffer> {
        int instancesCreated;

        private CountingChannelBufferFactory() {
        }

        public ChannelBuffer newInstance() {
            ++this.instancesCreated;
            return ChannelBuffers.dynamicBuffer();
        }
    }
}

