/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.junit.Assert;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.OnlineBackupExtensionFactory;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.ThreadTestUtils;

public class BackupServiceStressTestingBuilder {
    private BooleanSupplier untilCondition;
    private File storeDirectory;
    private File backupDirectory;
    private String backupHostname = "localhost";
    private int backupPort = 8200;

    public BackupServiceStressTestingBuilder until(BooleanSupplier untilCondition) {
        Objects.requireNonNull(untilCondition);
        this.untilCondition = untilCondition;
        return this;
    }

    public BackupServiceStressTestingBuilder withStore(File storeDirectory) {
        Objects.requireNonNull(storeDirectory);
        BackupServiceStressTestingBuilder.assertDirectoryExistsAndIsEmpty(storeDirectory);
        this.storeDirectory = storeDirectory;
        return this;
    }

    public BackupServiceStressTestingBuilder withBackupDirectory(File backupDirectory) {
        Objects.requireNonNull(backupDirectory);
        BackupServiceStressTestingBuilder.assertDirectoryExistsAndIsEmpty(backupDirectory);
        this.backupDirectory = backupDirectory;
        return this;
    }

    public BackupServiceStressTestingBuilder withBackupAddress(String hostname, int port) {
        Objects.requireNonNull(hostname);
        this.backupHostname = hostname;
        this.backupPort = port;
        return this;
    }

    public Callable<Integer> build() {
        Objects.requireNonNull(this.untilCondition, "must specify a condition");
        Objects.requireNonNull(this.storeDirectory, "must specify a directory containing the db to backup from");
        Objects.requireNonNull(this.backupDirectory, "must specify a directory where to save backups/broken stores");
        return new RunTest(this.untilCondition, this.storeDirectory, this.backupDirectory, this.backupHostname, this.backupPort);
    }

    private static void assertDirectoryExistsAndIsEmpty(File directory) {
        String path = directory.getAbsolutePath();
        if (!directory.exists()) {
            throw new IllegalArgumentException("Directory does not exist: '" + path + "'");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given File is not a directory: '" + path + "'");
        }
        if (directory.list().length > 0) {
            throw new IllegalArgumentException("Given directory is not empty: '" + path + "' " + Arrays.toString(directory.list()));
        }
    }

    private static class RunTest
    implements Callable<Integer> {
        private static final int NUMBER_OF_LABELS = 3;
        private static final int NUMBER_OF_RELATIONSHIP_TYPES = 5;
        private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        private final BooleanSupplier until;
        private final File storeDir;
        private final String backupHostname;
        private final int backupPort;
        private final File backupDir;
        private final File brokenDir;
        private final Label indexLabel;

        private RunTest(BooleanSupplier until, File storeDir, File backupDir, String backupHostname, int backupPort) {
            this.until = until;
            this.storeDir = storeDir;
            this.backupHostname = backupHostname;
            this.backupPort = backupPort;
            this.backupDir = new File(backupDir, "backup");
            this.fileSystem.mkdir(this.backupDir);
            this.brokenDir = new File(backupDir, "broken_stores");
            this.fileSystem.mkdir(this.brokenDir);
            this.indexLabel = RunTest.randomLabel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir.getAbsoluteFile()).setConfig(OnlineBackupSettings.online_backup_server, this.backupHostname + ":" + this.backupPort).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase();
            try {
                this.createIndex(db);
                this.createSomeData(db);
                this.rotateLogAndCheckPoint(db);
                final AtomicBoolean keepGoing = new AtomicBoolean(true);
                Dependencies dependencies = new Dependencies(db.getDependencyResolver());
                dependencies.satisfyDependencies(new Object[]{Config.empty(), NullLogProvider.getInstance(), new Monitors()});
                LifeSupport life = new LifeSupport();
                try {
                    SimpleKernelContext context = new SimpleKernelContext(this.fileSystem, this.storeDir, DatabaseInfo.UNKNOWN, (DependencySatisfier)dependencies);
                    OnlineBackupExtensionFactory.Dependencies extensionDeps = (OnlineBackupExtensionFactory.Dependencies)DependenciesProxy.dependencies((DependencyResolver)dependencies, OnlineBackupExtensionFactory.Dependencies.class);
                    life.add(new OnlineBackupExtensionFactory().newInstance((KernelContext)context, extensionDeps));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                life.start();
                ExecutorService executor = Executors.newFixedThreadPool(2);
                executor.execute(() -> {
                    while (keepGoing.get() && this.until.getAsBoolean()) {
                        this.createSomeData(db);
                    }
                });
                final AtomicInteger inconsistentDbs = new AtomicInteger(0);
                executor.submit(new Callable<Void>(){
                    private final BackupService backupService;
                    {
                        this.backupService = new BackupService(fileSystem, (LogProvider)NullLogProvider.getInstance(), new Monitors());
                    }

                    @Override
                    public Void call() throws IOException {
                        while (keepGoing.get() && until.getAsBoolean()) {
                            fileSystem.deleteRecursively(backupDir);
                            BackupService.BackupOutcome backupOutcome = this.backupService.doFullBackup(backupHostname, backupPort, backupDir.getAbsoluteFile(), ConsistencyCheck.FULL, Config.empty(), BackupClient.BIG_READ_TIMEOUT, false);
                            if (backupOutcome.isConsistent()) continue;
                            keepGoing.set(false);
                            int num = inconsistentDbs.incrementAndGet();
                            File dir = new File(brokenDir, "" + num);
                            fileSystem.mkdir(dir);
                            fileSystem.copyRecursively(backupDir, dir);
                        }
                        return null;
                    }
                });
                while (keepGoing.get() && this.until.getAsBoolean()) {
                    Thread.sleep(500L);
                }
                executor.shutdown();
                if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    ThreadTestUtils.dumpAllStackTraces();
                    Assert.fail((String)"Didn't manage to shut down the workers correctly, dumped threads for forensic purposes");
                }
                life.shutdown();
                Integer n = inconsistentDbs.get();
                return n;
            }
            finally {
                db.shutdown();
            }
        }

        private void createIndex(GraphDatabaseAPI db) {
            try (Transaction tx = db.beginTx();){
                db.schema().indexFor(this.indexLabel).on("name").create();
                tx.success();
            }
        }

        private void createSomeData(GraphDatabaseAPI db) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try (Transaction tx = db.beginTx();){
                Node start = this.createLabeledNode((GraphDatabaseService)db, random);
                Node end = this.createLabeledNode((GraphDatabaseService)db, random);
                Relationship rel = start.createRelationshipTo(end, RunTest.randomRelationshipType());
                rel.setProperty("something", (Object)("some " + ((Random)random).nextInt()));
                tx.success();
            }
        }

        private Node createLabeledNode(GraphDatabaseService db, Random random) {
            Node node = db.createNode(new Label[]{RunTest.randomLabel()});
            node.setProperty("name", (Object)("name'" + random.nextInt()));
            return node;
        }

        private void rotateLogAndCheckPoint(GraphDatabaseAPI db) throws IOException {
            ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
            ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        }

        private static Label randomLabel() {
            return Label.label((String)("" + ThreadLocalRandom.current().nextInt(3)));
        }

        private static RelationshipType randomRelationshipType() {
            String name = "" + ThreadLocalRandom.current().nextInt(5);
            return RelationshipType.withName((String)name);
        }
    }
}

