/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class BackupProtocolTest {
    @Test
    public void shouldGatherForensicsInFullBackupRequest() throws Exception {
        this.shouldGatherForensicsInFullBackupRequest(true);
    }

    @Test
    public void shouldSkipGatheringForensicsInFullBackupRequest() throws Exception {
        this.shouldGatherForensicsInFullBackupRequest(false);
    }

    @Test
    public void shouldHandleNoForensicsSpecifiedInFullBackupRequest() throws Exception {
        TheBackupInterface backup = (TheBackupInterface)Mockito.mock(TheBackupInterface.class);
        RequestContext ctx = new RequestContext(0L, 1, 0, -1L, 12L);
        TargetCaller targetCaller = BackupClient.BackupRequestType.FULL_BACKUP.getTargetCaller();
        targetCaller.call((Object)backup, ctx, ChannelBuffers.EMPTY_BUFFER, null);
        ((TheBackupInterface)Mockito.verify((Object)backup)).fullBackup((StoreWriter)Matchers.any(StoreWriter.class), Matchers.eq((boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldGatherForensicsInFullBackupRequest(boolean forensics) throws Exception {
        Response response = Response.EMPTY;
        StoreId storeId = response.getStoreId();
        String host = "localhost";
        int port = 6362;
        LifeSupport life = new LifeSupport();
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
        BackupClient client = (BackupClient)life.add((Lifecycle)new BackupClient(host, port, null, (LogProvider)NullLogProvider.getInstance(), storeId, 10000L, (ResponseUnpacker)Mockito.mock(ResponseUnpacker.class), (ByteCounterMonitor)Mockito.mock(ByteCounterMonitor.class), (RequestMonitor)Mockito.mock(RequestMonitor.class), (LogEntryReader)reader));
        ControlledBackupInterface backup = new ControlledBackupInterface();
        life.add((Lifecycle)new BackupServer((TheBackupInterface)backup, new HostnamePort(host, port), (LogProvider)NullLogProvider.getInstance(), (ByteCounterMonitor)Mockito.mock(ByteCounterMonitor.class), (RequestMonitor)Mockito.mock(RequestMonitor.class)));
        life.start();
        try {
            StoreWriter writer = (StoreWriter)Mockito.mock(StoreWriter.class);
            client.fullBackup(writer, forensics);
            Assert.assertEquals((Object)forensics, (Object)backup.receivedForensics);
        }
        finally {
            life.shutdown();
        }
    }

    private static class ControlledBackupInterface
    implements TheBackupInterface {
        private Boolean receivedForensics;

        private ControlledBackupInterface() {
        }

        public Response<Void> fullBackup(StoreWriter writer, boolean forensics) {
            this.receivedForensics = forensics;
            writer.close();
            return Response.EMPTY;
        }

        public Response<Void> incrementalBackup(RequestContext context) {
            throw new UnsupportedOperationException("Should be required");
        }
    }
}

