/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.server.configuration.ConfigLoader;

public class RestoreDatabaseCli
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;

    public RestoreDatabaseCli(Path homeDir, Path configDir) {
        this.homeDir = homeDir;
        this.configDir = configDir;
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        ConfigLoader configLoader = new ConfigLoader(RestoreDatabaseCli.settings());
        Config config = configLoader.loadOfflineConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()));
        return config.with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]);
    }

    public void execute(String[] incomingArguments) throws IncorrectUsage, CommandFailed {
        boolean forceOverwrite;
        String fromPath;
        String databaseName;
        Args args = Args.parse((String[])incomingArguments);
        try {
            databaseName = (String)args.interpretOption("database", Converters.mandatory(), s -> s, new Validator[0]);
            fromPath = (String)args.interpretOption("from", Converters.mandatory(), s -> s, new Validator[0]);
            forceOverwrite = args.getBoolean("force", Boolean.FALSE, Boolean.valueOf(true));
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        Config config = RestoreDatabaseCli.loadNeo4jConfig(this.homeDir, this.configDir, databaseName);
        RestoreDatabaseCommand restoreDatabaseCommand = new RestoreDatabaseCommand((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File(fromPath), config, databaseName, forceOverwrite);
        try {
            restoreDatabaseCommand.execute();
        }
        catch (IOException e) {
            throw new CommandFailed("Failed to restore database", (Exception)e);
        }
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    private static void printUsage(PrintStream out) {
        out.println("Neo4j Restore Tool");
        for (String line : Args.splitLongLine((String)"The restore tool is used to restore a backed up database", (int)80)) {
            out.println("\t" + line);
        }
        out.println("Usage:");
        out.println("--home-dir <path-to-neo4j>");
        out.println("--from <path-to-backup-directory>");
        out.println("--database <database-name>");
        out.println("--config <path-to-config-directory>");
        out.println("--force");
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("restore", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("--from=<backup-directory> --database=<database-name> [--force]");
        }

        public String description() {
            return "Restore a backed up database.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new RestoreDatabaseCli(homeDir, configDir);
        }
    }
}

