/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.server.configuration.ConfigLoader;

public class OnlineBackupCommand
implements AdminCommand {
    private static final String checkConsistencyArg = "check-consistency";
    private final BackupTool backupTool;
    private final Path homeDir;
    private final Path configDir;

    public OnlineBackupCommand(BackupTool backupTool, Path homeDir, Path configDir) {
        this.backupTool = backupTool;
        this.homeDir = homeDir;
        this.configDir = configDir;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        long timeout;
        Optional<Path> additionalConfig;
        ConsistencyCheck consistencyCheck;
        File destination;
        HostnamePort address;
        Args parsedArgs = Args.withFlags((String[])new String[]{checkConsistencyArg}).parse(args);
        try {
            address = this.parseAddress(parsedArgs);
            destination = this.parseDestination(parsedArgs);
            consistencyCheck = this.parseConsistencyCheck(parsedArgs);
            additionalConfig = this.parseAdditionalConfig(parsedArgs);
            timeout = this.parseTimeout(parsedArgs);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try {
            this.backupTool.executeBackup(address, destination, consistencyCheck, this.loadConfig(additionalConfig), timeout, false);
        }
        catch (BackupTool.ToolFailureException e) {
            throw new CommandFailed("backup failed: " + e.getMessage(), (Exception)e);
        }
    }

    private HostnamePort parseAddress(Args args) {
        HostnamePort defaultAddress = new HostnamePort("localhost", 6362);
        return (HostnamePort)args.interpretOption("from", Converters.withDefault((Object)defaultAddress), Converters.toHostnamePort((HostnamePort)defaultAddress), new Validator[0]);
    }

    private File parseDestination(Args parsedArgs) {
        return (File)parsedArgs.interpretOption("to", Converters.mandatory(), Converters.toFile(), new Validator[0]);
    }

    private ConsistencyCheck parseConsistencyCheck(Args args) {
        return args.getBoolean(checkConsistencyArg, Boolean.valueOf(true), Boolean.valueOf(true)) != false ? ConsistencyCheck.FULL : ConsistencyCheck.NONE;
    }

    private Optional<Path> parseAdditionalConfig(Args args) {
        return Optional.ofNullable(args.interpretOption("additional-config", Converters.optional(), Converters.toPath(), new Validator[0]));
    }

    private long parseTimeout(Args parsedArgs) {
        return parsedArgs.getDuration("timeout", TimeUnit.MINUTES.toMillis(20L));
    }

    private Config loadConfig(Optional<Path> additionalConfig) throws CommandFailed {
        return this.withAdditionalConfig(additionalConfig, new ConfigLoader(Arrays.asList(GraphDatabaseSettings.class, ConsistencyCheckSettings.class)).loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile())));
    }

    private Config withAdditionalConfig(Optional<Path> additionalConfig, Config config) throws CommandFailed {
        if (additionalConfig.isPresent()) {
            try {
                return config.with(MapUtil.load((File)additionalConfig.get().toFile()), new Class[0]);
            }
            catch (IOException e) {
                throw new CommandFailed("Could not read additional config from " + additionalConfig.get(), (Exception)e);
            }
        }
        return config;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("backup", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("[--from=<address>] --to=<backup-path> [--check-consistency] [--additional-config=<config-file-path>] [--timeout=<timeout>]");
        }

        public String description() {
            return "Perform a backup, over the network, from a running Neo4j server into a local copy of the database store (the backup). Neo4j Server must be configured to run a backup service. See http://neo4j.com/docs/operations-manual/current/backup/ for more details.\n\n<address> is a <host>:<port> pair like neo4j.example.com:1234; the host defaults to localhost and the port defaults to 6362, the default backup service port.\n\n<backup-path> is a directory where the backup will be made; if there is already a backup present an incremental backup will be made.\n\nConsistency checking is enabled by default.\n\n<timeout> is in the from <time>[ms|s|m|h]; the default is 20m; the default unit is seconds.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new OnlineBackupCommand(new BackupTool(new BackupService(outsideWorld.errorStream()), outsideWorld.errorStream()), homeDir, configDir);
        }
    }
}

