/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.test.rule.TestDirectory;

public class RestoreDatabaseCommandTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forceShouldRespectStoreLock() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String databaseName = "to";
        Config config = RestoreDatabaseCommandTest.configWith(Config.empty(), databaseName);
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        int fromNodeCount = 10;
        int toNodeCount = 20;
        this.createDbAt(fromPath, fromNodeCount);
        this.createDbAt(toPath, toNodeCount);
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fs);
        storeLocker.checkLock(toPath);
        try {
            new RestoreDatabaseCommand((FileSystemAbstraction)fs, fromPath, config, databaseName, true).execute();
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"the database is in use -- stop Neo4j and try again"));
        }
        finally {
            storeLocker.release();
        }
    }

    @Test
    public void shouldNotCopyOverAndExistingDatabase() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String databaseName = "to";
        Config config = RestoreDatabaseCommandTest.configWith(Config.empty(), databaseName);
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        this.createDbAt(fromPath, 0);
        this.createDbAt(toPath, 0);
        try {
            new RestoreDatabaseCommand((FileSystemAbstraction)fs, fromPath, config, databaseName, false).execute();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Database with name [to] already exists"));
        }
    }

    @Test
    public void shouldThrowExceptionIfBackupDirectoryDoesNotExist() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String databaseName = "to";
        Config config = RestoreDatabaseCommandTest.configWith(Config.empty(), databaseName);
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        this.createDbAt(toPath, 0);
        try {
            new RestoreDatabaseCommand((FileSystemAbstraction)fs, fromPath, config, databaseName, false).execute();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Source directory does not exist"));
        }
    }

    @Test
    public void shouldAllowForcedCopyOverAnExistingDatabase() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String databaseName = "to";
        Config config = RestoreDatabaseCommandTest.configWith(Config.empty(), databaseName);
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        int fromNodeCount = 10;
        int toNodeCount = 20;
        this.createDbAt(fromPath, fromNodeCount);
        this.createDbAt(toPath, toNodeCount);
        new RestoreDatabaseCommand((FileSystemAbstraction)fs, fromPath, config, databaseName, true).execute();
        GraphDatabaseService copiedDb = new GraphDatabaseFactory().newEmbeddedDatabase(toPath);
        try (Transaction ignored = copiedDb.beginTx();){
            Assert.assertEquals((long)fromNodeCount, (long)Iterables.count((Iterable)copiedDb.getAllNodes()));
        }
        copiedDb.shutdown();
    }

    public static Config configWith(Config config, String databaseName) {
        return config.with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]);
    }

    private void createDbAt(File fromPath, int nodesToCreate) {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseService db = factory.newEmbeddedDatabase(fromPath);
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < nodesToCreate; ++i) {
                db.createNode();
            }
            tx.success();
        }
        db.shutdown();
    }
}

