/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.OnlineBackupCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.TestDirectory;

public class OnlineBackupCommandTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private final BackupTool tool = (BackupTool)Mockito.mock(BackupTool.class);
    private OnlineBackupCommand command;
    private Path configDir;

    @Before
    public void setUp() throws Exception {
        this.configDir = this.testDirectory.directory("config-dir").toPath();
        this.command = new OnlineBackupCommand(this.tool, Paths.get("/some/path", new String[0]), this.configDir);
    }

    @Test
    public void shouldNotRequestForensics() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.eq((boolean)false));
    }

    @Test
    public void shouldDefaultFromToDefaultBackupAddress() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("localhost", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultPortAndPassHost() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldAcceptAHostWithATrailingColon() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 6362)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldDefaultHostAndPassPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=:1234", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("localhost", 1234)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassHostAndPort() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--from=foo.bar.server:1234", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.eq((Object)new HostnamePort("foo.bar.server", 1234)), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldPassDestination() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--to=/some/path/or/other");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.eq((Object)new File("/some/path/or/other")), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldTreatToArgumentAsMandatory() throws CommandFailed {
        try {
            this.execute(new String[0]);
            Assert.fail((String)"exception expected");
        }
        catch (IncorrectUsage incorrectUsage) {
            Assert.assertThat((Object)incorrectUsage.getMessage(), (Matcher)CoreMatchers.containsString((String)"to"));
        }
    }

    @Test
    public void shouldNotAskForConsistencyCheckIfNotSpecified() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--check-consistency=false", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.eq((Object)ConsistencyCheck.NONE), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldAskForConsistencyCheckIfSpecified() throws CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        this.execute("--check-consistency", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.eq((Object)ConsistencyCheck.FULL), (Config)Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean());
    }

    @Test
    public void shouldIncludeGraphDatabaseSettings() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).getSettingsClasses(), (Matcher)CoreMatchers.hasItem(GraphDatabaseSettings.class));
    }

    @Test
    public void shouldIncludeConsistencyCheckSettings() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).getSettingsClasses(), (Matcher)CoreMatchers.hasItem(ConsistencyCheckSettings.class));
    }

    @Test
    public void shouldReadStandardConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Files.write(this.configDir.resolve("neo4j.conf"), Arrays.asList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldAugmentConfig() throws IOException, CommandFailed, IncorrectUsage, BackupTool.ToolFailureException {
        Path extraConf = this.testDirectory.directory("someOtherDir").toPath().resolve("extra.conf");
        Files.write(extraConf, Arrays.asList(GraphDatabaseSettings.cypher_planner.name() + "=RULE"), new OpenOption[0]);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        this.execute("--additional-config=" + extraConf, "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)config.capture(), Matchers.anyLong(), Matchers.anyBoolean());
        Assert.assertThat((Object)((Config)config.getValue()).get(GraphDatabaseSettings.cypher_planner), (Matcher)CoreMatchers.is((Object)"RULE"));
    }

    @Test
    public void shouldDefaultTimeoutToTwentyMinutes() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.MINUTES.toMillis(20L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldInterpretAUnitlessTimeoutAsSeconds() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.SECONDS.toMillis(10L)), Matchers.anyBoolean());
    }

    @Test
    public void shouldParseATimeoutWithUnits() throws BackupTool.ToolFailureException, CommandFailed, IncorrectUsage {
        this.execute("--timeout=10h", "--to=/");
        ((BackupTool)Mockito.verify((Object)this.tool)).executeBackup((HostnamePort)Matchers.any(), (File)Matchers.any(), (ConsistencyCheck)Matchers.any(), (Config)Matchers.any(), Matchers.eq((long)TimeUnit.HOURS.toMillis(10L)), Matchers.anyBoolean());
    }

    private void execute(String ... args) throws IncorrectUsage, CommandFailed {
        this.command.execute(args);
    }
}

