/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.backup.ServerInterface;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;

public class EmbeddedServer
implements ServerInterface {
    private GraphDatabaseService db;

    public EmbeddedServer(File storeDir, String serverAddress) {
        GraphDatabaseBuilder graphDatabaseBuilder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir);
        graphDatabaseBuilder.setConfig(OnlineBackupSettings.online_backup_enabled, "true");
        graphDatabaseBuilder.setConfig(OnlineBackupSettings.online_backup_server, serverAddress);
        graphDatabaseBuilder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        this.db = graphDatabaseBuilder.newGraphDatabase();
    }

    @Override
    public void shutdown() {
        this.db.shutdown();
    }

    @Override
    public void awaitStarted() {
    }
}

