/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class BackupEmbeddedIT {
    @ClassRule
    public static final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule(testDirectory.directory("db")).startLazily();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.db);
    private static final String ip = "127.0.0.1";
    private final File backupPath = testDirectory.directory("backup-db");
    @Parameterized.Parameter
    public String recordFormat;

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormats() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void before() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        FileUtils.deleteDirectory((File)this.backupPath);
    }

    public static DbRepresentation createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)"Neo");
            db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        return DbRepresentation.of((GraphDatabaseService)db);
    }

    @Test
    public void makeSureBackupCanBePerformedWithDefaultPort() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        this.startDb(null);
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode("--from", ip, "--to", this.backupPath.getPath()));
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
        BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.db);
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode("--from", ip, "--to", this.backupPath.getPath()));
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    @Test
    public void makeSureBackupCanBePerformedWithCustomPort() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        int port = 4445;
        this.startDb("" + port);
        Assert.assertEquals((long)1L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode("--from", ip, "--to", this.backupPath.getPath()));
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode("--from", "127.0.0.1:" + port, "--to", this.backupPath.getPath()));
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
        BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.db);
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode("--from", "127.0.0.1:" + port, "--to", this.backupPath.getPath()));
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    private void startDb(String backupPort) {
        this.db.setConfig(GraphDatabaseSettings.record_format, this.recordFormat);
        this.db.setConfig(OnlineBackupSettings.online_backup_enabled, "true");
        if (backupPort != null) {
            this.db.setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + backupPort);
        }
        this.db.ensureStarted();
        BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.db);
    }

    public static int runBackupToolFromOtherJvmToGetExitCode(String ... args) throws Exception {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(ProcessUtil.getJavaExecutable().toString(), "-cp", ProcessUtil.getClassPath(), AdminTool.class.getName()));
        allArgs.add("backup");
        allArgs.addAll(Arrays.asList(args));
        Process process = Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
        return new ProcessStreamHandler(process, false).waitForResult();
    }

    private DbRepresentation getDbRepresentation() {
        return DbRepresentation.of((GraphDatabaseService)this.db);
    }

    private DbRepresentation getBackupDbRepresentation() {
        return DbRepresentation.of((File)this.backupPath);
    }
}

