/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.termination;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.gds.termination.TerminatedException;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.termination.TerminationMonitor;

public class TerminationFlagImpl
implements TerminationFlag {
    private static final long INTERVAL_MS = 10000L;
    private final TerminationMonitor terminationMonitor;
    private final Optional<Supplier<RuntimeException>> terminationCause;
    private volatile long lastCheck = 0L;
    private volatile boolean running = true;

    TerminationFlagImpl(TerminationMonitor terminationMonitor, Optional<Supplier<RuntimeException>> terminationCause) {
        this.terminationMonitor = terminationMonitor;
        this.terminationCause = terminationCause;
    }

    @Override
    public boolean running() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastCheck + 10000L) {
            if (this.terminationMonitor.isTerminated()) {
                this.running = false;
            }
            this.lastCheck = currentTime;
        }
        return this.running;
    }

    @Override
    public void terminate() {
        throw this.terminationCause.map(Supplier::get).orElseGet(TerminatedException::new);
    }
}

