/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.termination;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.gds.termination.TerminatedException;
import org.neo4j.gds.termination.TerminationFlagImpl;
import org.neo4j.gds.termination.TerminationMonitor;

@FunctionalInterface
public interface TerminationFlag {
    public static final TerminationFlag RUNNING_TRUE = () -> true;
    public static final TerminationFlag DEFAULT = () -> true;
    public static final TerminationFlag STOP_RUNNING = () -> false;
    public static final int RUN_CHECK_NODE_COUNT = 10000;

    public static TerminationFlag wrap(TerminationMonitor terminationMonitor) {
        return new TerminationFlagImpl(terminationMonitor, Optional.empty());
    }

    public static TerminationFlag wrap(TerminationMonitor terminationMonitor, Supplier<RuntimeException> terminationCause) {
        return new TerminationFlagImpl(terminationMonitor, Optional.of(terminationCause));
    }

    public boolean running();

    default public void assertRunning() {
        if (!this.running()) {
            this.terminate();
        }
    }

    default public void terminate() {
        throw new TerminatedException();
    }
}

