/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.warnings;

import java.util.function.Function;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.core.utils.progress.ProgressFeatureSettings;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogStore;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactoryProvider;
import org.neo4j.gds.core.utils.warnings.UserLogStore;
import org.neo4j.gds.core.utils.warnings.UserLogStoreHolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.internal.LogService;

public class UserLogRegistryExtension
extends ExtensionFactory<Dependencies> {
    private final Function<String, UserLogStore> userLogStoreSupplier;

    public UserLogRegistryExtension() {
        super(ExtensionType.DATABASE, "gds.warnings.registry");
        this.userLogStoreSupplier = UserLogStoreHolder::getUserLogStore;
    }

    @TestOnly
    public UserLogRegistryExtension(Function<String, UserLogStore> userLogStoreSupplier) {
        super(ExtensionType.DATABASE, "gds.warnings.registry");
        this.userLogStoreSupplier = userLogStoreSupplier;
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        GlobalProcedures registry = dependencies.globalProceduresRegistry();
        Boolean enabled = (Boolean)dependencies.config().get(ProgressFeatureSettings.progress_tracking_enabled);
        if (enabled.booleanValue()) {
            String databaseName = dependencies.graphDatabaseService().databaseName();
            UserLogStore userLogStore = this.userLogStoreSupplier.apply(databaseName);
            UserLogRegistryFactoryProvider userLogRegistryFactoryProvider = new UserLogRegistryFactoryProvider(userLogStore);
            registry.registerComponent(UserLogStore.class, ctx -> userLogStore, true);
            registry.registerComponent(UserLogRegistryFactory.class, (ThrowingFunction)userLogRegistryFactoryProvider, true);
            context.dependencySatisfier().satisfyDependency((Object)userLogStore);
        } else {
            registry.registerComponent(UserLogRegistryFactory.class, ctx -> EmptyUserLogRegistryFactory.INSTANCE, true);
            registry.registerComponent(UserLogStore.class, ctx -> EmptyUserLogStore.INSTANCE, true);
            context.dependencySatisfier().satisfyDependency((Object)EmptyUserLogRegistryFactory.INSTANCE);
            context.dependencySatisfier().satisfyDependency((Object)EmptyUserLogStore.INSTANCE);
        }
        return new LifecycleAdapter();
    }

    static interface Dependencies {
        public Config config();

        public LogService logService();

        public GlobalProcedures globalProceduresRegistry();

        public GraphDatabaseService graphDatabaseService();
    }
}

