/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.warnings;

import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.values.storable.LocalTimeValue;

public class UserLogEntry {
    public String taskName;
    public String message;
    public LocalTimeValue timeStarted;

    public UserLogEntry(Task task, String message) {
        this.taskName = task.description();
        this.message = message;
        this.timeStarted = LocalTimeValue.localTime((LocalTime)LocalTime.ofInstant(Instant.ofEpochMilli(task.startTime()), ZoneId.systemDefault()));
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getMessage() {
        return this.message;
    }

    public LocalTimeValue getTimeStarted() {
        return this.timeStarted;
    }
}

