/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.warnings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.warnings.UserLogEntry;
import org.neo4j.gds.core.utils.warnings.UserLogStore;

public class PerDatabaseUserLogStore
implements UserLogStore {
    public static final int MOST_RECENT = 100;
    private final Map<String, ConcurrentSkipListMap<Task, List<String>>> registeredMessages = new ConcurrentHashMap<String, ConcurrentSkipListMap<Task, List<String>>>();

    @Override
    public Stream<UserLogEntry> query(String username) {
        if (this.registeredMessages.containsKey(username)) {
            return this.registeredMessages.get(username).entrySet().stream().flatMap(PerDatabaseUserLogStore::fromEntryToUserLog);
        }
        return Stream.empty();
    }

    private static Stream<UserLogEntry> fromEntryToUserLog(Map.Entry<Task, List<String>> entry) {
        return entry.getValue().stream().map(message -> new UserLogEntry((Task)entry.getKey(), (String)message));
    }

    private synchronized void pollLeastRecentElement(String username) {
        ConcurrentSkipListMap<Task, List<String>> usernameMap = this.registeredMessages.get(username);
        if (usernameMap.size() > 100) {
            usernameMap.pollFirstEntry();
        }
    }

    private ConcurrentSkipListMap<Task, List<String>> getUserStore(String username) {
        return this.registeredMessages.computeIfAbsent(username, __ -> new ConcurrentSkipListMap(Comparator.comparingLong(Task::startTime)));
    }

    private boolean shouldConsiderTask(SortedMap<Task, List<String>> usernameMap, Task taskId) {
        if (usernameMap.size() < 100) {
            return true;
        }
        Task leastRecentCachedTask = usernameMap.firstKey();
        return leastRecentCachedTask.startTime() <= taskId.startTime();
    }

    @Override
    public void addUserLogMessage(String username, Task taskId, String message) {
        ConcurrentSkipListMap<Task, List<String>> usernameMap = this.getUserStore(username);
        if (this.shouldConsiderTask(usernameMap, taskId)) {
            AtomicBoolean addedInStore = new AtomicBoolean();
            usernameMap.computeIfAbsent(taskId, __ -> {
                addedInStore.set(true);
                return Collections.synchronizedList(new ArrayList());
            }).add(message);
            if (addedInStore.get() && usernameMap.size() > 100) {
                this.pollLeastRecentElement(username);
            }
        }
    }
}

