/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.core.utils.progress.tasks.IterativeTask;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;

public final class Tasks {
    private static final Task EMPTY_TASK = new Task("", List.of());

    public static Task empty() {
        return EMPTY_TASK;
    }

    public static Task task(String description, List<Task> children) {
        return new Task(description, children);
    }

    public static Task task(String description, Task firstChild, Task ... children) {
        ArrayList<Task> childrenList = new ArrayList<Task>();
        childrenList.add(firstChild);
        childrenList.addAll(Arrays.asList(children));
        return new Task(description, childrenList);
    }

    public static IterativeTask iterativeFixed(String description, Supplier<List<Task>> subTasksSupplier, int iterations) {
        return new IterativeTask(description, Tasks.unrollTasks(subTasksSupplier, iterations), subTasksSupplier, IterativeTask.Mode.FIXED);
    }

    public static IterativeTask iterativeDynamic(String description, Supplier<List<Task>> subTasksSupplier, int iterations) {
        return new IterativeTask(description, Tasks.unrollTasks(subTasksSupplier, iterations), subTasksSupplier, IterativeTask.Mode.DYNAMIC);
    }

    public static IterativeTask iterativeOpen(String description, Supplier<List<Task>> subTasksSupplier) {
        return new IterativeTask(description, new ArrayList<Task>(), subTasksSupplier, IterativeTask.Mode.OPEN);
    }

    public static LeafTask leaf(String description) {
        return Tasks.leaf(description, -1L);
    }

    public static LeafTask leaf(String description, long volume) {
        return new LeafTask(description, volume);
    }

    private static List<Task> unrollTasks(Supplier<List<Task>> subTasksSupplier, int iterations) {
        return Stream.generate(subTasksSupplier).limit(iterations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Tasks() {
    }
}

