/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskRegistry;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.tasks.LogLevel;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Status;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressLogger;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistry;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.logging.Log;

public class TaskProgressTracker
implements ProgressTracker {
    private static final long UNKNOWN_STEPS = -1L;
    private final Task baseTask;
    private final TaskRegistry taskRegistry;
    private final UserLogRegistry userLogRegistry;
    private final TaskProgressLogger taskProgressLogger;
    private final Stack<Task> nestedTasks;
    protected Optional<Task> currentTask;
    private long currentTotalSteps;
    private double progressLeftOvers;
    private final Consumer<RuntimeException> onError;

    public TaskProgressTracker(Task baseTask, Log log, int concurrency, TaskRegistryFactory taskRegistryFactory) {
        this(baseTask, log, concurrency, new JobId(), taskRegistryFactory, EmptyUserLogRegistryFactory.INSTANCE);
    }

    public TaskProgressTracker(Task baseTask, Log log, int concurrency, JobId jobId, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        this(baseTask, jobId, taskRegistryFactory, new TaskProgressLogger(log, baseTask, concurrency), userLogRegistryFactory);
    }

    protected TaskProgressTracker(Task baseTask, JobId jobId, TaskRegistryFactory taskRegistryFactory, TaskProgressLogger taskProgressLogger, UserLogRegistryFactory userLogRegistryFactory) {
        this.baseTask = baseTask;
        this.taskRegistry = taskRegistryFactory.newInstance(jobId);
        this.taskProgressLogger = taskProgressLogger;
        this.currentTask = Optional.empty();
        this.currentTotalSteps = -1L;
        this.progressLeftOvers = 0.0;
        this.nestedTasks = new Stack();
        this.userLogRegistry = userLogRegistryFactory.newInstance();
        if (GdsFeatureToggles.FAIL_ON_PROGRESS_TRACKER_ERRORS.isEnabled()) {
            this.onError = error -> {
                throw error;
            };
        } else {
            AtomicBoolean didLog = new AtomicBoolean(false);
            this.onError = error -> {
                if (!didLog.get()) {
                    taskProgressLogger.logWarning(String.format(Locale.US, ":: %s", error.getMessage()));
                    didLog.set(true);
                }
            };
        }
    }

    @Override
    public void setEstimatedResourceFootprint(MemoryRange memoryRangeInBytes, int maxConcurrency) {
        this.baseTask.setEstimatedMemoryRangeInBytes(memoryRangeInBytes);
        this.baseTask.setMaxConcurrency(maxConcurrency);
    }

    @Override
    public void beginSubTask() {
        this.registerBaseTask();
        Task nextTask = this.currentTask.map(task -> {
            this.nestedTasks.add((Task)task);
            try {
                return task.nextSubtask();
            }
            catch (IllegalStateException e) {
                this.onError.accept(e);
                return this.baseTask;
            }
        }).orElse(this.baseTask);
        nextTask.start();
        this.taskProgressLogger.logBeginSubTask(nextTask, this.parentTask());
        this.currentTask = Optional.of(nextTask);
        this.currentTotalSteps = -1L;
        this.progressLeftOvers = 0.0;
    }

    @Override
    public void beginSubTask(String expectedTaskDescription) {
        this.beginSubTask();
        this.assertSubTask(expectedTaskDescription);
    }

    @Override
    public void beginSubTask(long taskVolume) {
        this.beginSubTask();
        this.setVolume(taskVolume);
    }

    @Override
    public void setSteps(long steps) {
        if (steps <= 0L) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Total steps for task must be at least 1 but was %d", (Object[])new Object[]{steps}));
        }
        this.currentTotalSteps = steps;
    }

    @Override
    public void logSteps(long steps) {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            long volume = this.currentTask.get().getProgress().volume();
            double progress = (double)(steps * volume) / (double)this.currentTotalSteps + this.progressLeftOvers;
            long longProgress = (long)progress;
            this.progressLeftOvers = progress - (double)longProgress;
            this.logProgress(longProgress);
        }
    }

    @Override
    public void beginSubTask(String expectedTaskDescription, long taskVolume) {
        this.beginSubTask();
        this.assertSubTask(expectedTaskDescription);
        this.setVolume(taskVolume);
    }

    @Override
    public void endSubTask() {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            this.taskProgressLogger.logEndSubTask(this.currentTask.get(), this.parentTask());
            this.currentTask.get().finish();
            if (this.nestedTasks.isEmpty()) {
                this.currentTask = Optional.empty();
                this.release();
            } else {
                this.currentTask = Optional.of(this.nestedTasks.pop());
            }
        }
    }

    @Override
    public void endSubTask(String expectedTaskDescription) {
        this.assertSubTask(expectedTaskDescription);
        this.endSubTask();
    }

    @Override
    public void logProgress(long value) {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            this.currentTask.get().logProgress(value);
            this.taskProgressLogger.logProgress(value);
        }
    }

    @Override
    public void logProgress(long value, String messageTemplate) {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            this.currentTask.get().logProgress(value);
            this.taskProgressLogger.logMessage(StringFormatting.formatWithLocale((String)messageTemplate, (Object[])new Object[]{value}));
        }
    }

    @Override
    public void setVolume(long volume) {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            this.currentTask.get().setVolume(volume);
            this.taskProgressLogger.reset(volume);
        }
    }

    @Override
    public long currentVolume() {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            return this.currentTask.get().getProgress().volume();
        }
        return -1L;
    }

    @Override
    public void logMessage(LogLevel level, String message) {
        switch (level) {
            case WARNING: {
                this.userLogRegistry.addWarningToLog(this.baseTask, message);
                this.taskProgressLogger.logWarning(":: " + message);
                break;
            }
            case INFO: {
                this.taskProgressLogger.logMessage(":: " + message);
                break;
            }
            case DEBUG: {
                this.taskProgressLogger.logDebug(":: " + message);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown log level " + level);
            }
        }
    }

    @Override
    public void logDebug(Supplier<String> messageSupplier) {
        this.taskProgressLogger.logDebug(messageSupplier);
    }

    @Override
    public void release() {
        this.taskRegistry.unregisterTask();
        this.taskProgressLogger.release();
        this.validateTaskNotRunning();
    }

    @Override
    public void endSubTaskWithFailure() {
        this.requireCurrentTask();
        if (this.currentTask.isPresent()) {
            this.currentTask.get().fail();
            this.taskProgressLogger.logEndSubTaskWithFailure(this.currentTask.get(), this.parentTask());
            if (this.nestedTasks.isEmpty()) {
                this.currentTask = Optional.empty();
                this.release();
            } else {
                this.currentTask = Optional.of(this.nestedTasks.pop());
                this.endSubTaskWithFailure();
            }
        }
    }

    @Override
    public void endSubTaskWithFailure(String expectedTaskDescription) {
        this.assertSubTask(expectedTaskDescription);
        this.endSubTaskWithFailure();
    }

    @TestOnly
    Task currentSubTask() {
        this.requireCurrentTask();
        return this.currentTask.orElseThrow();
    }

    @Nullable
    private Task parentTask() {
        return this.nestedTasks.isEmpty() ? null : this.nestedTasks.peek();
    }

    private void registerBaseTask() {
        if (!this.taskRegistry.containsTask(this.baseTask)) {
            this.taskRegistry.registerTask(this.baseTask);
        }
    }

    private void requireCurrentTask() {
        if (this.currentTask.isEmpty()) {
            this.onError.accept(new IllegalStateException("Tried to log progress, but there are no running tasks being tracked"));
        }
    }

    private void validateTaskNotRunning() {
        if (this.baseTask.status() == Status.RUNNING) {
            String message = StringFormatting.formatWithLocale((String)"Attempted to release algorithm, but task %s is still running", (Object[])new Object[]{this.baseTask.description()});
            assert (false) : message;
            this.taskProgressLogger.logWarning(message);
        }
    }

    private void assertSubTask(String subTaskSubString) {
        if (this.currentTask.isPresent()) {
            String currentTaskDescription = this.currentTask.get().description();
            assert (currentTaskDescription.contains(subTaskSubString)) : StringFormatting.formatWithLocale((String)"Expected task name to contain `%s`, but was `%s`", (Object[])new Object[]{subTaskSubString, currentTaskDescription});
        }
    }
}

