/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.core.utils.ClockService;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.ImmutableProgress;
import org.neo4j.gds.core.utils.progress.tasks.Progress;
import org.neo4j.gds.core.utils.progress.tasks.Status;
import org.neo4j.gds.core.utils.progress.tasks.TaskVisitor;
import org.neo4j.gds.utils.StringFormatting;

public class Task {
    public static final int UNKNOWN_VOLUME = -1;
    public static final int UNKNOWN_CONCURRENCY = -1;
    public static final long NOT_STARTED = -1L;
    public static final long NOT_FINISHED = -1L;
    private final String description;
    private final List<Task> subTasks;
    private Status status;
    private long startTime;
    private long finishTime;
    private MemoryRange estimatedMemoryRangeInBytes = MemoryRange.empty();
    private int maxConcurrency = -1;

    public Task(String description, List<Task> subTasks) {
        this.description = description;
        this.subTasks = subTasks;
        this.status = Status.PENDING;
        this.startTime = -1L;
        this.finishTime = -1L;
    }

    public String description() {
        return this.description;
    }

    public List<Task> subTasks() {
        return this.subTasks;
    }

    public Status status() {
        return this.status;
    }

    public Task nextSubtask() {
        this.validateTaskIsRunning();
        return this.nextSubTaskAfterValidation();
    }

    public void start() {
        if (this.status != Status.PENDING) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Task `%s` with state %s cannot be started", (Object[])new Object[]{this.description, this.status}));
        }
        this.status = Status.RUNNING;
        this.startTime = ClockService.clock().millis();
    }

    public void finish() {
        if (this.status != Status.RUNNING) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Task `%s` with state %s cannot be finished", (Object[])new Object[]{this.description, this.status}));
        }
        this.status = Status.FINISHED;
        this.finishTime = ClockService.clock().millis();
    }

    public void cancel() {
        if (this.status == Status.FINISHED) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Task `%s` with state %s cannot be canceled", (Object[])new Object[]{this.description, this.status}));
        }
        this.status = Status.CANCELED;
    }

    public Progress getProgress() {
        MutableLong volume = new MutableLong(0L);
        MutableLong progress = new MutableLong(0L);
        this.subTasks().stream().map(Task::getProgress).forEach(childProgress -> {
            if (childProgress.volume() == -1L || volume.getValue() == -1L) {
                volume.setValue(-1L);
            } else {
                volume.add(childProgress.volume());
            }
            progress.add(childProgress.progress());
        });
        return ImmutableProgress.builder().volume(volume.getValue()).progress(progress.getValue()).build();
    }

    public void setVolume(long volume) {
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Should only be called on a leaf task, but task `%s` is not a leaf", (Object[])new Object[]{this.description}));
    }

    public void logProgress() {
        this.logProgress(1L);
    }

    public void logProgress(long value) {
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Should only be called on a leaf task, but task `%s` is not a leaf", (Object[])new Object[]{this.description}));
    }

    public void visit(TaskVisitor taskVisitor) {
        taskVisitor.visitIntermediateTask(this);
    }

    public long startTime() {
        return this.startTime;
    }

    public long finishTime() {
        return this.finishTime;
    }

    public boolean hasNotStarted() {
        return this.status() == Status.PENDING || this.startTime() == -1L;
    }

    public MemoryRange estimatedMemoryRangeInBytes() {
        return this.estimatedMemoryRangeInBytes;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        this.subTasks.forEach(task -> {
            if (task.maxConcurrency() == -1) {
                task.setMaxConcurrency(maxConcurrency);
            }
        });
    }

    public void setEstimatedMemoryRangeInBytes(MemoryRange memoryRangeInBytes) {
        this.estimatedMemoryRangeInBytes = memoryRangeInBytes;
    }

    public void fail() {
        this.status = Status.FAILED;
    }

    protected Task nextSubTaskAfterValidation() {
        if (this.subTasks.stream().anyMatch(t -> t.status == Status.RUNNING)) {
            throw new IllegalStateException("Cannot move to next subtask, because some subtasks are still running");
        }
        return this.subTasks().stream().filter(t -> t.status() == Status.PENDING).findFirst().orElseThrow(() -> new IllegalStateException("No more pending subtasks"));
    }

    private void validateTaskIsRunning() {
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Cannot retrieve next subtask, task `%s` is not running.", (Object[])new Object[]{this.description()}));
        }
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        Task.render(sb, this, 0);
        return sb.toString();
    }

    static void render(StringBuilder sb, Task task, int depth) {
        sb.append("\t".repeat(Math.max(0, depth - 1)));
        if (depth > 0) {
            sb.append("|-- ");
        }
        sb.append(task.description).append('(').append((Object)task.status).append(')').append(System.lineSeparator());
        task.subTasks().forEach(subtask -> Task.render(sb, subtask, depth + 1));
    }
}

