/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.function.Supplier;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.tasks.LogLevel;

public interface ProgressTracker {
    public static final ProgressTracker NULL_TRACKER = new EmptyProgressTracker();

    public void setEstimatedResourceFootprint(MemoryRange var1, int var2);

    public void beginSubTask();

    public void beginSubTask(long var1);

    public void beginSubTask(String var1);

    public void beginSubTask(String var1, long var2);

    public void endSubTask();

    public void endSubTask(String var1);

    public void endSubTaskWithFailure();

    public void endSubTaskWithFailure(String var1);

    public void logProgress(long var1);

    default public void logProgress() {
        this.logProgress(1L);
    }

    public void logProgress(long var1, String var3);

    public void setVolume(long var1);

    public long currentVolume();

    public void logDebug(Supplier<String> var1);

    default public void logDebug(String message) {
        this.logMessage(LogLevel.DEBUG, message);
    }

    default public void logWarning(String message) {
        this.logMessage(LogLevel.WARNING, message);
    }

    default public void logInfo(String message) {
        this.logMessage(LogLevel.INFO, message);
    }

    public void logMessage(LogLevel var1, String var2);

    public void release();

    public void setSteps(long var1);

    public void logSteps(long var1);

    public static class EmptyProgressTracker
    implements ProgressTracker {
        @Override
        public void setEstimatedResourceFootprint(MemoryRange memoryRangeInBytes, int concurrency) {
        }

        @Override
        public void beginSubTask() {
        }

        @Override
        public void beginSubTask(long taskVolume) {
        }

        @Override
        public void endSubTask() {
        }

        @Override
        public void beginSubTask(String expectedTaskDescription) {
        }

        @Override
        public void beginSubTask(String expectedTaskDescription, long taskVolume) {
        }

        @Override
        public void endSubTask(String expectedTaskDescription) {
        }

        @Override
        public void logProgress(long value) {
        }

        @Override
        public void logProgress(long value, String messageTemplate) {
        }

        @Override
        public void setVolume(long volume) {
        }

        @Override
        public long currentVolume() {
            return -1L;
        }

        @Override
        public void setSteps(long steps) {
        }

        @Override
        public void logSteps(long steps) {
        }

        @Override
        public void logMessage(LogLevel level, String message) {
        }

        @Override
        public void logDebug(Supplier<String> messageSupplier) {
        }

        @Override
        public void release() {
        }

        @Override
        public void endSubTaskWithFailure() {
        }

        @Override
        public void endSubTaskWithFailure(String expectedTaskDescription) {
        }
    }
}

