/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.gds.core.utils.progress.tasks.ImmutableProgress;
import org.neo4j.gds.core.utils.progress.tasks.Progress;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskVisitor;

public class LeafTask
extends Task {
    private long volume;
    private final LongAdder currentProgress;

    public LeafTask(String description, long volume) {
        super(description, List.of());
        this.volume = volume;
        this.currentProgress = new LongAdder();
    }

    @Override
    public void finish() {
        super.finish();
        if (this.volume == -1L) {
            this.volume = this.currentProgress.longValue();
        }
        this.currentProgress.add(this.volume - this.currentProgress.longValue());
    }

    @Override
    public void setVolume(long volume) {
        this.volume = volume;
    }

    @Override
    public void logProgress(long value) {
        this.currentProgress.add(value);
    }

    @Override
    public Progress getProgress() {
        return ImmutableProgress.of(this.currentProgress.longValue(), this.volume);
    }

    @Override
    public void visit(TaskVisitor taskVisitor) {
        taskVisitor.visitLeafTask(this);
    }
}

