/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.core.utils.progress.EmptyTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.EmptyTaskStore;
import org.neo4j.gds.core.utils.progress.ProgressFeatureSettings;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactoryProvider;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.TaskStoreHolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.internal.LogService;

@Deprecated
public final class TaskRegistryExtension
extends ExtensionFactory<Dependencies> {
    public TaskRegistryExtension() {
        super(ExtensionType.DATABASE, "gds.task.registry");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        GlobalProcedures registry = dependencies.globalProceduresRegistry();
        Boolean enabled = (Boolean)dependencies.config().get(ProgressFeatureSettings.progress_tracking_enabled);
        final String databaseName = dependencies.graphDatabaseService().databaseName();
        if (enabled.booleanValue()) {
            TaskStore taskStore = TaskStoreHolder.getTaskStore(databaseName);
            TaskRegistryFactoryProvider taskRegistryFactoryProvider = new TaskRegistryFactoryProvider(taskStore);
            registry.registerComponent(TaskStore.class, ctx -> taskStore, true);
            registry.registerComponent(TaskRegistryFactory.class, (ThrowingFunction)taskRegistryFactoryProvider, true);
            context.dependencySatisfier().satisfyDependency((Object)taskStore);
        } else {
            registry.registerComponent(TaskRegistryFactory.class, ctx -> EmptyTaskRegistryFactory.INSTANCE, true);
            registry.registerComponent(TaskStore.class, ctx -> EmptyTaskStore.INSTANCE, true);
            context.dependencySatisfier().satisfyDependency((Object)EmptyTaskRegistryFactory.INSTANCE);
            context.dependencySatisfier().satisfyDependency((Object)EmptyTaskStore.INSTANCE);
        }
        return new LifecycleAdapter(){

            public void shutdown() {
                TaskStoreHolder.purge(databaseName);
            }
        };
    }

    static interface Dependencies {
        public Config config();

        public LogService logService();

        public GlobalProcedures globalProceduresRegistry();

        public GraphDatabaseService graphDatabaseService();
    }
}

