/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import java.util.function.Supplier;

public interface ProgressLogger {
    public static final String TASK_SEPARATOR = " :: ";
    public static final Supplier<String> NO_MESSAGE = () -> null;

    public String getTask();

    public void setTask(String var1);

    default public void logProgress() {
        this.logProgress(NO_MESSAGE);
    }

    public void logProgress(Supplier<String> var1);

    default public void logProgress(long progress) {
        this.logProgress(progress, NO_MESSAGE);
    }

    public void logProgress(long var1, Supplier<String> var3);

    public void logMessage(Supplier<String> var1);

    public void logFinishPercentage();

    default public void logMessage(String msg) {
        this.logMessage(() -> msg);
    }

    public void logDebug(Supplier<String> var1);

    default public void logDebug(String msg) {
        this.logDebug(() -> msg);
    }

    public void logWarning(String var1);

    public void logError(String var1);

    default public void logStart() {
        this.logStart("");
    }

    default public void logStart(String message) {
        this.logMessage((message + " :: Start").trim());
    }

    default public void logFinish() {
        this.logFinish("");
    }

    default public ProgressLogger logFinish(String message) {
        this.logMessage((message + " :: Finished").trim());
        return this;
    }

    default public ProgressLogger logFinishWithFailure() {
        return this.logFinishWithFailure("");
    }

    default public ProgressLogger logFinishWithFailure(String message) {
        this.logMessage((message + " :: Failed").trim());
        return this;
    }

    default public ProgressLogger logFinishSubtaskWithFailure(String subTaskName) {
        this.logFinishWithFailure();
        int endIndex = this.getTask().indexOf(TASK_SEPARATOR + subTaskName);
        if (endIndex == -1) {
            throw new IllegalArgumentException("Unknown subtask: " + subTaskName);
        }
        String task = this.getTask().substring(0, endIndex);
        this.setTask(task);
        return this;
    }

    default public ProgressLogger startSubTask(String subTaskName) {
        this.setTask(this.getTask() + TASK_SEPARATOR + subTaskName);
        this.logStart();
        return this;
    }

    default public ProgressLogger finishSubTask(String subTaskName) {
        this.logFinish();
        int endIndex = this.getTask().indexOf(TASK_SEPARATOR + subTaskName);
        if (endIndex == -1) {
            throw new IllegalArgumentException("Unknown subtask: " + subTaskName);
        }
        String task = this.getTask().substring(0, endIndex);
        this.setTask(task);
        return this;
    }

    public long reset(long var1);

    public void release();
}

