/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.neo4j.gds.core.utils.progress.ImmutableUserTask;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.tasks.Task;

public class PerDatabaseTaskStore
implements TaskStore {
    private final Map<String, Map<JobId, Task>> registeredTasks = new ConcurrentHashMap<String, Map<JobId, Task>>();

    @Override
    public void store(String username, JobId jobId, Task task) {
        this.registeredTasks.computeIfAbsent(username, __ -> new ConcurrentHashMap()).put(jobId, task);
    }

    @Override
    public void remove(String username, JobId jobId) {
        if (this.registeredTasks.containsKey(username)) {
            this.registeredTasks.get(username).remove(jobId);
        }
    }

    @Override
    public Stream<TaskStore.UserTask> query() {
        return this.registeredTasks.entrySet().stream().flatMap(tasksPerUsers -> ((Map)tasksPerUsers.getValue()).entrySet().stream().map(jobTask -> ImmutableUserTask.of((String)tasksPerUsers.getKey(), (JobId)jobTask.getKey(), (Task)jobTask.getValue())));
    }

    @Override
    public Stream<TaskStore.UserTask> query(JobId jobId) {
        return this.query().filter(userTask -> userTask.jobId().equals(jobId));
    }

    @Override
    public Stream<TaskStore.UserTask> query(String username) {
        return this.registeredTasks.getOrDefault(username, Map.of()).entrySet().stream().map(jobIdTask -> ImmutableUserTask.of(username, (JobId)jobIdTask.getKey(), (Task)jobIdTask.getValue()));
    }

    @Override
    public Optional<TaskStore.UserTask> query(String username, JobId jobId) {
        if (this.registeredTasks.containsKey(username)) {
            return Optional.ofNullable(this.registeredTasks.get(username).get(jobId)).map(task -> ImmutableUserTask.of(username, jobId, task));
        }
        return Optional.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.registeredTasks.values().stream().allMatch(Map::isEmpty);
    }

    @Override
    public long taskCount() {
        return this.registeredTasks.values().stream().mapToLong(Map::size).sum();
    }
}

