/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public final class JobId {
    private final String value;

    public JobId() {
        this.value = UUID.randomUUID().toString();
    }

    public JobId(UUID id) {
        this(id.toString());
    }

    public JobId(String id) {
        this.value = id;
    }

    public String asString() {
        return this.value;
    }

    public String toString() {
        return "JobId(" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobId that = (JobId)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static JobId parse(Object input) {
        if (input instanceof String) {
            return new JobId((String)input);
        }
        if (input instanceof JobId) {
            return (JobId)input;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Expected JobId or String. Got %s.", input.getClass().getSimpleName()));
    }

    public static String asString(JobId jobId) {
        return jobId.asString();
    }
}

