/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.tasks.Task;

@ParametersAreNonnullByDefault
@Generated(from="TaskStore.UserTask", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableUserTask
implements TaskStore.UserTask {
    private final String username;
    private final JobId jobId;
    private final Task task;

    private ImmutableUserTask(String username, JobId jobId, Task task) {
        this.username = Objects.requireNonNull(username, "username");
        this.jobId = Objects.requireNonNull(jobId, "jobId");
        this.task = Objects.requireNonNull(task, "task");
    }

    private ImmutableUserTask(ImmutableUserTask original, String username, JobId jobId, Task task) {
        this.username = username;
        this.jobId = jobId;
        this.task = task;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    @Override
    public Task task() {
        return this.task;
    }

    public final ImmutableUserTask withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableUserTask(this, newValue, this.jobId, this.task);
    }

    public final ImmutableUserTask withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return new ImmutableUserTask(this, this.username, newValue, this.task);
    }

    public final ImmutableUserTask withTask(Task value) {
        if (this.task == value) {
            return this;
        }
        Task newValue = Objects.requireNonNull(value, "task");
        return new ImmutableUserTask(this, this.username, this.jobId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserTask && this.equalTo(0, (ImmutableUserTask)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserTask another) {
        return this.username.equals(another.username) && this.jobId.equals(another.jobId) && this.task.equals(another.task);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.task.hashCode();
        return h;
    }

    public String toString() {
        return "UserTask{username=" + this.username + ", jobId=" + this.jobId + ", task=" + this.task + "}";
    }

    public static TaskStore.UserTask of(String username, JobId jobId, Task task) {
        return new ImmutableUserTask(username, jobId, task);
    }

    public static TaskStore.UserTask copyOf(TaskStore.UserTask instance) {
        if (instance instanceof ImmutableUserTask) {
            return (ImmutableUserTask)instance;
        }
        return ImmutableUserTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TaskStore.UserTask", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_JOB_ID = 2L;
        private static final long INIT_BIT_TASK = 4L;
        private long initBits = 7L;
        @Nullable
        private String username;
        @Nullable
        private JobId jobId;
        @Nullable
        private Task task;

        private Builder() {
        }

        public final Builder from(TaskStore.UserTask instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.jobId(instance.jobId());
            this.task(instance.task());
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder task(Task task) {
            this.task = Objects.requireNonNull(task, "task");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.username = null;
            this.jobId = null;
            this.task = null;
            return this;
        }

        public TaskStore.UserTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserTask(null, this.username, this.jobId, this.task);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("jobId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("task");
            }
            return "Cannot build UserTask, some of required attributes are not set " + attributes;
        }
    }
}

