/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.core.utils.progress.ProgressLogger;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.utils.CloseableThreadLocal;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.logging.Log;

public class BatchingProgressLogger
implements ProgressLogger {
    public static final long MAXIMUM_LOG_INTERVAL = (long)Math.pow(2.0, 13.0);
    private final Log log;
    private final int concurrency;
    private long taskVolume;
    private long batchSize;
    private String taskName;
    private final LongAdder progressCounter;
    private final CloseableThreadLocal<MutableLong> callCounter;
    private int globalPercentage;

    private static long calculateBatchSize(Task task, int concurrency) {
        return BatchingProgressLogger.calculateBatchSize(Math.max(1L, task.getProgress().volume()), concurrency);
    }

    private static long calculateBatchSize(long taskVolume, int concurrency) {
        long batchSize = taskVolume / 100L;
        return Math.max(1L, BitUtil.nextHighestPowerOfTwo((long)(batchSize /= (long)concurrency)));
    }

    public BatchingProgressLogger(Log log, Task task, int concurrency) {
        this(log, task, BatchingProgressLogger.calculateBatchSize(task, concurrency), concurrency);
    }

    public BatchingProgressLogger(Log log, Task task, long batchSize, int concurrency) {
        this.log = log;
        this.taskVolume = task.getProgress().volume();
        this.batchSize = batchSize;
        this.taskName = task.description();
        this.progressCounter = new LongAdder();
        this.callCounter = CloseableThreadLocal.withInitial(MutableLong::new);
        this.concurrency = concurrency;
        this.globalPercentage = -1;
    }

    @Override
    public String getTask() {
        return this.taskName;
    }

    @Override
    public void setTask(String task) {
        this.taskName = task;
    }

    @Override
    public void logProgress(Supplier<String> msgFactory) {
        MutableLong localProgress = (MutableLong)this.callCounter.get();
        if (localProgress.incrementAndGet() >= this.batchSize) {
            this.doLogPercentage(msgFactory, 1L);
            localProgress.setValue(0L);
        } else {
            this.progressCounter.increment();
        }
    }

    @Override
    public void logProgress(long progress, Supplier<String> msgFactory) {
        if (progress == 0L) {
            return;
        }
        MutableLong localProgress = (MutableLong)this.callCounter.get();
        if (localProgress.addAndGet(progress) >= this.batchSize) {
            this.doLogPercentage(msgFactory, progress);
            localProgress.setValue(localProgress.longValue() & this.batchSize - 1L);
        } else {
            this.progressCounter.add(progress);
        }
    }

    @Override
    public void logFinishPercentage() {
        if (this.globalPercentage < 100) {
            this.logProgress(100);
        }
    }

    @Override
    public void release() {
        this.callCounter.close();
    }

    private synchronized void doLogPercentage(Supplier<String> msgFactory, long progress) {
        String message = msgFactory != NO_MESSAGE ? msgFactory.get() : null;
        this.progressCounter.add(progress);
        int nextPercentage = (int)((double)this.progressCounter.sum() / (double)this.taskVolume * 100.0);
        if (this.globalPercentage < nextPercentage) {
            this.globalPercentage = nextPercentage;
            if (message == null || message.isEmpty()) {
                this.logProgress(nextPercentage);
            } else {
                this.logProgressWithMessage(nextPercentage, message);
            }
        }
    }

    private void logProgress(int nextPercentage) {
        this.logInfo(StringFormatting.formatWithLocale((String)"[%s] %s %d%%", (Object[])new Object[]{Thread.currentThread().getName(), this.taskName, nextPercentage}));
    }

    private void logProgressWithMessage(int nextPercentage, String msg) {
        this.logInfo(StringFormatting.formatWithLocale((String)"[%s] %s %d%% %s", (Object[])new Object[]{Thread.currentThread().getName(), this.taskName, nextPercentage, msg}));
    }

    @Override
    public void logMessage(String msg) {
        this.log.info("[%s] %s %s", new Object[]{Thread.currentThread().getName(), this.taskName, msg});
    }

    @Override
    public void logMessage(Supplier<String> msg) {
        this.logMessage(Objects.requireNonNull(msg.get()));
    }

    private void logInfo(String message) {
        this.log.info(message);
    }

    @Override
    public void logDebug(Supplier<String> msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[%s] %s %s", new Object[]{Thread.currentThread().getName(), this.taskName, msg.get()});
        }
    }

    @Override
    public void logWarning(String message) {
        this.log.warn("[%s] %s %s", new Object[]{Thread.currentThread().getName(), this.taskName, message});
    }

    @Override
    public void logError(String message) {
        this.log.error("[%s] %s %s", new Object[]{Thread.currentThread().getName(), this.taskName, message});
    }

    @Override
    public long reset(long newTaskVolume) {
        long remainingVolume = this.taskVolume - this.progressCounter.sum();
        this.taskVolume = newTaskVolume;
        this.batchSize = BatchingProgressLogger.calculateBatchSize(newTaskVolume, this.concurrency);
        this.progressCounter.reset();
        this.globalPercentage = -1;
        return remainingVolume;
    }
}

