/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel.proc;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.utils.StringFormatting;

final class PregelBaseProc {
    static <ALGO extends Algorithm<PregelResult>, CONFIG extends PregelConfig> List<NodeProperty> nodeProperties(ComputationResult<ALGO, PregelResult, CONFIG> computationResult, String propertyPrefix) {
        NodeValue compositeNodeValue = ((PregelResult)computationResult.result()).nodeValues();
        PregelSchema schema = compositeNodeValue.schema();
        return schema.elements().stream().filter(element -> element.visibility() == PregelSchema.Visibility.PUBLIC).map(element -> {
            Object nodePropertyValues;
            String propertyKey = element.propertyKey();
            switch (element.propertyType()) {
                case LONG: {
                    nodePropertyValues = compositeNodeValue.longProperties(propertyKey).asNodeProperties();
                    break;
                }
                case DOUBLE: {
                    nodePropertyValues = compositeNodeValue.doubleProperties(propertyKey).asNodeProperties();
                    break;
                }
                case LONG_ARRAY: {
                    nodePropertyValues = new HugeObjectArrayLongArrayPropertyValues((HugeObjectArray<long[]>)compositeNodeValue.longArrayProperties(propertyKey));
                    break;
                }
                case DOUBLE_ARRAY: {
                    nodePropertyValues = new HugeObjectArrayDoubleArrayPropertyValues((HugeObjectArray<double[]>)compositeNodeValue.doubleArrayProperties(propertyKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported property type: " + element.propertyType());
                }
            }
            return ImmutableNodeProperty.of((String)StringFormatting.formatWithLocale((String)"%s%s", (Object[])new Object[]{propertyPrefix, propertyKey}), (NodePropertyValues)nodePropertyValues);
        }).collect(Collectors.toList());
    }

    private PregelBaseProc() {
    }

    static class HugeObjectArrayDoubleArrayPropertyValues
    implements DoubleArrayNodePropertyValues {
        private final HugeObjectArray<double[]> doubleArrays;

        HugeObjectArrayDoubleArrayPropertyValues(HugeObjectArray<double[]> doubleArrays) {
            this.doubleArrays = doubleArrays;
        }

        public long size() {
            return this.doubleArrays.size();
        }

        public double[] doubleArrayValue(long nodeId) {
            return (double[])this.doubleArrays.get(nodeId);
        }
    }

    static class HugeObjectArrayLongArrayPropertyValues
    implements LongArrayNodePropertyValues {
        private final HugeObjectArray<long[]> longArrays;

        HugeObjectArrayLongArrayPropertyValues(HugeObjectArray<long[]> longArrays) {
            this.longArrays = longArrays;
        }

        public long size() {
            return this.longArrays.size();
        }

        public long[] longArrayValue(long nodeId) {
            return (long[])this.longArrays.get(nodeId);
        }
    }
}

