/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import org.neo4j.gds.CommunityProcCompanion;
import org.neo4j.gds.api.ProcedureReturnColumns;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.modularityoptimization.ModularityOptimization;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationConfig;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationResult;
import org.neo4j.gds.nodeproperties.ConsecutiveLongNodePropertyValues;
import org.neo4j.gds.result.AbstractCommunityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;

final class ModularityOptimizationProc {
    static final String MODULARITY_OPTIMIZATION_DESCRIPTION = "The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.";

    ModularityOptimizationProc() {
    }

    static <PROC_RESULT, CONFIG extends ModularityOptimizationConfig> AbstractResultBuilder<PROC_RESULT> resultBuilder(ModularityOptimizationResultBuilder<PROC_RESULT> procResultBuilder, ComputationResult<ModularityOptimization, ModularityOptimizationResult, CONFIG> computeResult) {
        ModularityOptimizationResult result = (ModularityOptimizationResult)computeResult.result();
        return procResultBuilder.withModularity(result.modularity()).withRanIterations(result.ranIterations()).didConverge(result.didConverge()).withCommunityFunction(arg_0 -> ((ModularityOptimizationResult)result).communityId(arg_0)).withConfig(computeResult.config());
    }

    static <CONFIG extends ModularityOptimizationConfig> NodePropertyValues nodeProperties(ComputationResult<ModularityOptimization, ModularityOptimizationResult, CONFIG> computationResult) {
        LongNodePropertyValues resultCommunities = ((ModularityOptimizationResult)computationResult.result()).asNodeProperties();
        if (((ModularityOptimizationConfig)computationResult.config()).consecutiveIds()) {
            return new ConsecutiveLongNodePropertyValues(resultCommunities);
        }
        return resultCommunities;
    }

    static <CONFIG extends ModularityOptimizationConfig> NodePropertyValues nodeProperties(ComputationResult<ModularityOptimization, ModularityOptimizationResult, CONFIG> computationResult, String resultProperty) {
        ModularityOptimizationConfig config = (ModularityOptimizationConfig)computationResult.config();
        return CommunityProcCompanion.nodeProperties((ConcurrencyConfig)config, (String)resultProperty, (LongNodePropertyValues)((ModularityOptimizationResult)computationResult.result()).asNodeProperties(), () -> computationResult.graphStore().nodeProperty(config.seedProperty()));
    }

    static abstract class ModularityOptimizationResultBuilder<PROC_RESULT>
    extends AbstractCommunityResultBuilder<PROC_RESULT> {
        long ranIterations;
        boolean didConverge;
        double modularity;

        ModularityOptimizationResultBuilder(ProcedureReturnColumns returnColumns, int concurrency) {
            super(returnColumns, concurrency);
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }

        ModularityOptimizationResultBuilder<PROC_RESULT> withModularity(double modularity) {
            this.modularity = modularity;
            return this;
        }
    }
}

