/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.undirected;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.beta.undirected.ToUndirected;
import org.neo4j.gds.beta.undirected.ToUndirectedAlgorithmFactory;
import org.neo4j.gds.beta.undirected.ToUndirectedConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;

@GdsCallable(name="gds.beta.graph.relationships.toUndirected", executionMode=ExecutionMode.MUTATE_RELATIONSHIP, description="The ToUndirected procedure converts directed relationships to undirected relationships")
public class ToUndirectedSpec
implements AlgorithmSpec<ToUndirected, SingleTypeRelationships, ToUndirectedConfig, Stream<MutateResult>, ToUndirectedAlgorithmFactory> {
    public static final String DESCRIPTION = "The ToUndirected procedure converts directed relationships to undirected relationships";

    public String name() {
        return "gds.beta.graph.relationships.toUndirected";
    }

    public ToUndirectedAlgorithmFactory algorithmFactory() {
        return new ToUndirectedAlgorithmFactory();
    }

    public NewConfigFunction<ToUndirectedConfig> newConfigFunction() {
        return (__, config) -> ToUndirectedConfig.of((CypherMapWrapper)config);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ToUndirected, SingleTypeRelationships, ToUndirectedConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder().withInputRelationships(computeResult.graph().relationshipCount());
    }

    public ComputationResultConsumer<ToUndirected, SingleTypeRelationships, ToUndirectedConfig, Stream<MutateResult>> computationResultConsumer() {
        return new MutateComputationResultConsumer<ToUndirected, SingleTypeRelationships, ToUndirectedConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<ToUndirected, SingleTypeRelationships, ToUndirectedConfig> computationResult, ExecutionContext executionContext) {
                computationResult.graphStore().addRelationshipType((SingleTypeRelationships)computationResult.result());
                resultBuilder.withRelationshipsWritten(((SingleTypeRelationships)computationResult.result()).topology().elementCount());
            }
        };
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long inputRelationships;
        public final long relationshipsWritten;

        private MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long postProcessingMillis, long inputRelationships, long relationshipsWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, mutateMillis, configuration);
            this.inputRelationships = inputRelationships;
            this.relationshipsWritten = relationshipsWritten;
        }

        public static class Builder
        extends AbstractResultBuilder<MutateResult> {
            private long inputRelationships;

            Builder withInputRelationships(long inputRelationships) {
                this.inputRelationships = inputRelationships;
                return this;
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, 0L, this.inputRelationships, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

