/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.indexInverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.beta.indexInverse.InverseRelationships;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsAlgorithmFactory;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;

@GdsCallable(name="gds.beta.graph.relationships.indexInverse", executionMode=ExecutionMode.MUTATE_RELATIONSHIP, description="The IndexInverse procedure indexes directed relationships to allow an efficient inverse access for other algorithms.")
public class IndexInverseSpec
implements AlgorithmSpec<InverseRelationships, Map<RelationshipType, SingleTypeRelationships>, InverseRelationshipsConfig, Stream<MutateResult>, InverseRelationshipsAlgorithmFactory> {
    public static final String DESCRIPTION = "The IndexInverse procedure indexes directed relationships to allow an efficient inverse access for other algorithms.";
    static final String CALLABLE_NAME = "gds.beta.graph.relationships.indexInverse";

    public String name() {
        return CALLABLE_NAME;
    }

    public InverseRelationshipsAlgorithmFactory algorithmFactory() {
        return new InverseRelationshipsAlgorithmFactory();
    }

    public NewConfigFunction<InverseRelationshipsConfig> newConfigFunction() {
        return (__, config) -> InverseRelationshipsConfig.of((CypherMapWrapper)config);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<InverseRelationships, Map<RelationshipType, SingleTypeRelationships>, InverseRelationshipsConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder().withInputRelationships(computeResult.graph().relationshipCount());
    }

    public ComputationResultConsumer<InverseRelationships, Map<RelationshipType, SingleTypeRelationships>, InverseRelationshipsConfig, Stream<MutateResult>> computationResultConsumer() {
        return new MutateComputationResultConsumer<InverseRelationships, Map<RelationshipType, SingleTypeRelationships>, InverseRelationshipsConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<InverseRelationships, Map<RelationshipType, SingleTypeRelationships>, InverseRelationshipsConfig> computationResult, ExecutionContext executionContext) {
                Map result = (Map)computationResult.result();
                GraphStore graphStore = computationResult.graphStore();
                if (result != null) {
                    result.forEach((type, inverseRelationships) -> graphStore.addInverseIndex(type, inverseRelationships.topology(), inverseRelationships.properties()));
                }
            }
        };
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long inputRelationships;

        private MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long postProcessingMillis, long inputRelationships, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, mutateMillis, configuration);
            this.inputRelationships = inputRelationships;
        }

        public static class Builder
        extends AbstractResultBuilder<MutateResult> {
            private long inputRelationships;

            Builder withInputRelationships(long inputRelationships) {
                this.inputRelationships = inputRelationships;
                return this;
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, 0L, this.inputRelationships, this.config.toMap());
            }
        }
    }
}

