/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.indexInverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.beta.indexInverse.IndexInverseSpec;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.executor.ProcedureExecutorSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class IndexInverseProc
extends BaseProc {
    @Internal
    @Procedure(value="gds.beta.graph.relationships.indexInverse", mode=Mode.READ)
    @Description(value="The IndexInverse procedure indexes directed relationships to allow an efficient inverse access for other algorithms.")
    public Stream<IndexInverseSpec.MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        IndexInverseSpec mutateSpec = new IndexInverseSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)mutateSpec, (ExecutorSpec)pipelineSpec, this.executionContext()).compute(graphName, configuration);
    }

    @Internal
    @Procedure(value="gds.beta.graph.relationships.indexInverse.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        IndexInverseSpec mutateSpec = new IndexInverseSpec();
        ProcedureExecutorSpec pipelineSpec = new ProcedureExecutorSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)mutateSpec, (ExecutorSpec)pipelineSpec, this.executionContext(), this.transactionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

