/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.ProcedureReturnColumns;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringMutateConfig;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.k1coloring.mutate", description="The K-1 Coloring algorithm assigns a color to every node in the graph.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class K1ColoringMutateProc
extends MutatePropertyProc<K1Coloring, HugeLongArray, MutateResult, K1ColoringMutateConfig> {
    @Procedure(value="gds.beta.k1coloring.mutate", mode=Mode.READ)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.k1coloring.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected K1ColoringMutateConfig newConfig(String username, CypherMapWrapper config) {
        return K1ColoringMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<K1Coloring, K1ColoringMutateConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<K1Coloring, HugeLongArray, K1ColoringMutateConfig> computeResult, ExecutionContext executionContext) {
        return K1ColoringProc.resultBuilder(new MutateResult.Builder(executionContext.returnColumns(), ((K1ColoringMutateConfig)computeResult.config()).concurrency()), computeResult, executionContext.returnColumns());
    }

    protected NodePropertyValues nodeProperties(ComputationResult<K1Coloring, HugeLongArray, K1ColoringMutateConfig> computationResult) {
        return K1ColoringProc.nodeProperties(computationResult);
    }

    public static class MutateResult {
        public static final MutateResult EMPTY = new MutateResult(0L, 0L, 0L, 0L, 0L, 0L, false, null);
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long nodeCount;
        public final long colorCount;
        public final long ranIterations;
        public final boolean didConverge;
        public Map<String, Object> configuration;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long nodeCount, long colorCount, long ranIterations, boolean didConverge, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.nodeCount = nodeCount;
            this.colorCount = colorCount;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.configuration = configuration;
        }

        static class Builder
        extends K1ColoringProc.K1ColoringResultBuilder<MutateResult> {
            Builder(ProcedureReturnColumns returnColumns, int concurrency) {
                super(returnColumns, concurrency);
            }

            protected MutateResult buildResult() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.nodeCount, this.colorCount, this.ranIterations, this.didConverge, this.config.toMap());
            }
        }
    }
}

