/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.api.ProcedureReturnColumns;
import org.neo4j.gds.beta.closeness.ClosenessCentrality;
import org.neo4j.gds.beta.closeness.ClosenessCentralityProc;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.beta.closeness.ClosenessCentralityStatsConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardStatsResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ClosenessCentralityStatsProc
extends StatsProc<ClosenessCentrality, ClosenessCentralityResult, StatsResult, ClosenessCentralityStatsConfig> {
    @Procedure(value="gds.beta.closeness.stats", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<StatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(this.compute(graphName, configuration));
    }

    public AlgorithmFactory<?, ClosenessCentrality, ClosenessCentralityStatsConfig> algorithmFactory() {
        return ClosenessCentralityProc.algorithmFactory();
    }

    protected ClosenessCentralityStatsConfig newConfig(String username, CypherMapWrapper config) {
        return ClosenessCentralityStatsConfig.of((CypherMapWrapper)config);
    }

    protected AbstractResultBuilder<StatsResult> resultBuilder(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityStatsConfig> computeResult, ExecutionContext executionContext) {
        return ClosenessCentralityProc.resultBuilder(new StatsResult.Builder(executionContext.returnColumns(), ((ClosenessCentralityStatsConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static class StatsResult
    extends StandardStatsResult {
        public final Map<String, Object> centralityDistribution;

        StatsResult(@Nullable Map<String, Object> centralityDistribution, long preProcessingMillis, long computeMillis, long postProcessingMillis, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, configuration);
            this.centralityDistribution = centralityDistribution;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<StatsResult> {
            private Builder(ProcedureReturnColumns returnColumns, int concurrency) {
                super(returnColumns, concurrency);
            }

            public StatsResult buildResult() {
                return new StatsResult(this.centralityHistogram, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.config.toMap());
            }
        }
    }
}

