/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.modularityoptimization.ModularityOptimization;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationFactory;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationProc;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationWriteConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.modularityOptimization.write", description="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class ModularityOptimizationWriteProc
extends WriteProc<ModularityOptimization, ModularityOptimization, WriteResult, ModularityOptimizationWriteConfig> {
    @Procedure(name="gds.beta.modularityOptimization.write", mode=Mode.WRITE)
    @Description(value="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.modularityOptimization.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ModularityOptimizationWriteConfig newConfig(String username, CypherMapWrapper config) {
        return ModularityOptimizationWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<ModularityOptimization, ModularityOptimizationWriteConfig> algorithmFactory() {
        return new ModularityOptimizationFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationWriteConfig> computationResult) {
        return ModularityOptimizationProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationWriteConfig> computeResult, ExecutionContext executionContext) {
        return ModularityOptimizationProc.resultBuilder(new WriteResult.Builder(this.callContext, ((ModularityOptimizationWriteConfig)computeResult.config()).concurrency()), computeResult);
    }

    public static class WriteResult {
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public boolean didConverge;
        public long ranIterations;
        public double modularity;
        public final long communityCount;
        public final Map<String, Object> communityDistribution;
        public final Map<String, Object> configuration;

        WriteResult(long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodes, boolean didConverge, long ranIterations, double modularity, long communityCount, Map<String, Object> communityDistribution, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.nodes = nodes;
            this.didConverge = didConverge;
            this.ranIterations = ranIterations;
            this.modularity = modularity;
            this.communityCount = communityCount;
            this.communityDistribution = communityDistribution;
            this.configuration = configuration;
        }

        static class Builder
        extends ModularityOptimizationProc.ModularityOptimizationResultBuilder<WriteResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            protected WriteResult buildResult() {
                return new WriteResult(this.preProcessingMillis, this.computeMillis, this.postProcessingDuration, this.writeMillis, this.nodeCount, this.didConverge, this.ranIterations, this.modularity, this.maybeCommunityCount.orElse(0L), this.communityHistogramOrNull(), this.config.toMap());
            }
        }
    }
}

