/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.node2vec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.node2vec.Node2VecCompanion;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.node2vec.Node2Vec;
import org.neo4j.gds.embeddings.node2vec.Node2VecAlgorithmFactory;
import org.neo4j.gds.embeddings.node2vec.Node2VecModel;
import org.neo4j.gds.embeddings.node2vec.Node2VecStreamConfig;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.node2vec.stream", description="The Node2Vec algorithm computes embeddings for nodes based on random walks.", executionMode=ExecutionMode.STREAM)
public class Node2VecStreamProc
extends StreamProc<Node2Vec, Node2VecModel.Result, StreamResult, Node2VecStreamConfig> {
    @Procedure(value="gds.beta.node2vec.stream", mode=Mode.READ)
    @Description(value="The Node2Vec algorithm computes embeddings for nodes based on random walks.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream(computationResult);
    }

    @Procedure(value="gds.beta.node2vec.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected Node2VecStreamConfig newConfig(String username, CypherMapWrapper config) {
        return Node2VecStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Node2Vec, Node2VecStreamConfig> algorithmFactory() {
        return new Node2VecAlgorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<Node2Vec, Node2VecModel.Result, Node2VecStreamConfig> computationResult) {
        return Node2VecCompanion.nodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new StreamResult(originalNodeId, nodePropertyValues.floatArrayValue(internalNodeId));
    }

    public static class StreamResult {
        public long nodeId;
        public List<Double> embedding;

        StreamResult(long nodeId, float[] embedding) {
            this.nodeId = nodeId;
            this.embedding = new ArrayList<Double>(embedding.length);
            for (float f : embedding) {
                this.embedding.add(Double.valueOf(f));
            }
        }
    }
}

