/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.modularity.ModularityOptimization;
import org.neo4j.gds.modularity.ModularityOptimizationFactory;
import org.neo4j.gds.modularity.ModularityOptimizationMutateConfig;
import org.neo4j.gds.modularity.ModularityOptimizationProc;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.modularityOptimization.mutate", description="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ModularityOptimizationMutateProc
extends MutatePropertyProc<ModularityOptimization, ModularityOptimization, MutateResult, ModularityOptimizationMutateConfig> {
    @Procedure(value="gds.beta.modularityOptimization.mutate", mode=Mode.READ)
    @Description(value="The Modularity Optimization algorithm groups the nodes in the graph by optimizing the graphs modularity.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.modularityOptimization.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodePropertyValues nodeProperties(ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationMutateConfig> computationResult) {
        return ModularityOptimizationProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ModularityOptimization, ModularityOptimization, ModularityOptimizationMutateConfig> computeResult, ExecutionContext executionContext) {
        return ModularityOptimizationProc.resultBuilder(new MutateResult.Builder(executionContext.callContext(), ((ModularityOptimizationMutateConfig)computeResult.config()).concurrency()), computeResult);
    }

    protected ModularityOptimizationMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ModularityOptimizationMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<ModularityOptimization, ModularityOptimizationMutateConfig> algorithmFactory() {
        return new ModularityOptimizationFactory();
    }

    public static class MutateResult {
        public final long preProcessingMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public boolean didConverge;
        public long ranIterations;
        public double modularity;
        public final long communityCount;
        public final Map<String, Object> communityDistribution;
        public final Map<String, Object> configuration;

        MutateResult(long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, long nodes, boolean didConverge, long ranIterations, double modularity, long communityCount, Map<String, Object> communityDistribution, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.nodes = nodes;
            this.didConverge = didConverge;
            this.ranIterations = ranIterations;
            this.modularity = modularity;
            this.communityCount = communityCount;
            this.communityDistribution = communityDistribution;
            this.configuration = configuration;
        }

        static class Builder
        extends ModularityOptimizationProc.ModularityOptimizationResultBuilder<MutateResult> {
            Builder(ProcedureCallContext context, int concurrency) {
                super(context, concurrency);
            }

            protected MutateResult buildResult() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.postProcessingDuration, this.mutateMillis, this.nodeCount, this.didConverge, this.ranIterations, this.modularity, this.maybeCommunityCount.orElse(0L), this.communityHistogramOrNull(), this.config.toMap());
            }
        }
    }
}

