/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.closeness.ClosenessCentrality;
import org.neo4j.gds.beta.closeness.ClosenessCentralityProc;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.beta.closeness.ClosenessCentralityStreamConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.closeness.stream", description="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.STREAM)
public class ClosenessCentralityStreamProc
extends StreamProc<ClosenessCentrality, ClosenessCentralityResult, StreamResult, ClosenessCentralityStreamConfig> {
    public String name() {
        return "ClosenessCentrality";
    }

    @Procedure(value="gds.beta.closeness.stream", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return this.stream(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new StreamResult(originalNodeId, nodePropertyValues.doubleValue(internalNodeId));
    }

    protected NodePropertyValues nodeProperties(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityStreamConfig> computationResult) {
        return ClosenessCentralityProc.nodeProperties(computationResult);
    }

    protected ClosenessCentralityStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ClosenessCentralityStreamConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<ClosenessCentralityStreamConfig> validationConfig() {
        return ClosenessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<ClosenessCentrality, ClosenessCentralityStreamConfig> algorithmFactory() {
        return ClosenessCentralityProc.algorithmFactory();
    }

    public static final class StreamResult {
        public final long nodeId;
        public final double score;

        StreamResult(long nodeId, double score) {
            this.nodeId = nodeId;
            this.score = score;
        }
    }
}

