/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.closeness.ClosenessCentrality;
import org.neo4j.gds.beta.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.beta.closeness.ClosenessCentralityFactory;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.validation.BeforeLoadValidation;
import org.neo4j.gds.executor.validation.GraphProjectConfigValidations;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;

public final class ClosenessCentralityProc {
    static final String DESCRIPTION = "Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    private ClosenessCentralityProc() {
    }

    static <CONFIG extends ClosenessCentralityConfig> NodePropertyValues nodeProperties(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, CONFIG> computeResult) {
        return ((ClosenessCentralityResult)computeResult.result()).centralities().asNodeProperties();
    }

    static <CONFIG extends ClosenessCentralityConfig> GraphAlgorithmFactory<ClosenessCentrality, CONFIG> algorithmFactory() {
        return new ClosenessCentralityFactory();
    }

    static <PROC_RESULT, CONFIG extends ClosenessCentralityConfig> AbstractCentralityResultBuilder<PROC_RESULT> resultBuilder(AbstractCentralityResultBuilder<PROC_RESULT> procResultBuilder, ComputationResult<ClosenessCentrality, ClosenessCentralityResult, CONFIG> computeResult) {
        if (computeResult.result() != null) {
            HugeDoubleArray centralities = ((ClosenessCentralityResult)computeResult.result()).centralities();
            procResultBuilder.withCentralityFunction(arg_0 -> ((HugeDoubleArray)centralities).get(arg_0));
        }
        return procResultBuilder;
    }

    static <CONFIG extends ClosenessCentralityConfig> ValidationConfiguration<CONFIG> getValidationConfig() {
        return new ValidationConfiguration<CONFIG>(){

            public List<BeforeLoadValidation<CONFIG>> beforeLoadValidations() {
                return List.of(new GraphProjectConfigValidations.OrientationValidation());
            }
        };
    }
}

