/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringProc;
import org.neo4j.gds.beta.k1coloring.K1ColoringStreamConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.k1coloring.stream", description="The K-1 Coloring algorithm assigns a color to every node in the graph.", executionMode=ExecutionMode.STREAM)
public class K1ColoringStreamProc
extends StreamProc<K1Coloring, HugeLongArray, StreamResult, K1ColoringStreamConfig> {
    @Procedure(name="gds.beta.k1coloring.stream", mode=Mode.READ)
    @Description(value="The K-1 Coloring algorithm assigns a color to every node in the graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.beta.k1coloring.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected K1ColoringStreamConfig newConfig(String username, CypherMapWrapper config) {
        return K1ColoringStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<K1Coloring, K1ColoringStreamConfig> algorithmFactory() {
        return new K1ColoringFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        return new StreamResult(originalNodeId, nodePropertyValues.longValue(internalNodeId));
    }

    protected NodePropertyValues nodeProperties(ComputationResult<K1Coloring, HugeLongArray, K1ColoringStreamConfig> computationResult) {
        return K1ColoringProc.nodeProperties(computationResult);
    }

    public static class StreamResult {
        public final long nodeId;
        public final long color;

        StreamResult(long nodeId, long color) {
            this.nodeId = nodeId;
            this.color = color;
        }
    }
}

