/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.closeness.ClosenessCentrality;
import org.neo4j.gds.beta.closeness.ClosenessCentralityProc;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.beta.closeness.ClosenessCentralityWriteConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardWriteResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.closeness.write", description="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class ClosenessCentralityWriteProc
extends WriteProc<ClosenessCentrality, ClosenessCentralityResult, WriteResult, ClosenessCentralityWriteConfig> {
    public String name() {
        return "ClosenessCentrality";
    }

    @Procedure(value="gds.beta.closeness.write", mode=Mode.WRITE)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<WriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    protected ClosenessCentralityWriteConfig newConfig(String username, CypherMapWrapper config) {
        return ClosenessCentralityWriteConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<ClosenessCentralityWriteConfig> validationConfig() {
        return ClosenessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<ClosenessCentrality, ClosenessCentralityWriteConfig> algorithmFactory() {
        return ClosenessCentralityProc.algorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityWriteConfig> computationResult) {
        return ClosenessCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<WriteResult> resultBuilder(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityWriteConfig> computeResult, ExecutionContext executionContext) {
        return ClosenessCentralityProc.resultBuilder(new WriteResult.Builder(this.callContext, ((ClosenessCentralityWriteConfig)computeResult.config()).concurrency()).withWriteProperty(((ClosenessCentralityWriteConfig)computeResult.config()).writeProperty()), computeResult);
    }

    public static final class WriteResult
    extends StandardWriteResult {
        public final long nodePropertiesWritten;
        public final String writeProperty;
        public final Map<String, Object> centralityDistribution;

        WriteResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long writeMillis, String writeProperty, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, writeMillis, config);
            this.writeProperty = writeProperty;
            this.centralityDistribution = centralityDistribution;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<WriteResult> {
            public String writeProperty;

            private Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public Builder withWriteProperty(String writeProperty) {
                this.writeProperty = writeProperty;
                return this;
            }

            public WriteResult buildResult() {
                return new WriteResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.writeMillis, this.writeProperty, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

