/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.closeness.ClosenessCentrality;
import org.neo4j.gds.beta.closeness.ClosenessCentralityMutateConfig;
import org.neo4j.gds.beta.closeness.ClosenessCentralityProc;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.beta.closeness.mutate", description="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ClosenessCentralityMutateProc
extends MutatePropertyProc<ClosenessCentrality, ClosenessCentralityResult, MutateResult, ClosenessCentralityMutateConfig> {
    public String name() {
        return "ClosenessCentrality";
    }

    @Procedure(value="gds.beta.closeness.mutate", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    protected ClosenessCentralityMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ClosenessCentralityMutateConfig.of((CypherMapWrapper)config);
    }

    public ValidationConfiguration<ClosenessCentralityMutateConfig> validationConfig() {
        return ClosenessCentralityProc.getValidationConfig();
    }

    public GraphAlgorithmFactory<ClosenessCentrality, ClosenessCentralityMutateConfig> algorithmFactory() {
        return ClosenessCentralityProc.algorithmFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityMutateConfig> computationResult) {
        return ClosenessCentralityProc.nodeProperties(computationResult);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ClosenessCentrality, ClosenessCentralityResult, ClosenessCentralityMutateConfig> computeResult, ExecutionContext executionContext) {
        MutateResult.Builder procResultBuilder = new MutateResult.Builder(executionContext.callContext(), ((ClosenessCentralityMutateConfig)computeResult.config()).concurrency()).withMutateProperty(((ClosenessCentralityMutateConfig)computeResult.config()).mutateProperty());
        return ClosenessCentralityProc.resultBuilder(procResultBuilder, computeResult);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;
        public final String mutateProperty;
        public final Map<String, Object> centralityDistribution;

        MutateResult(long nodePropertiesWritten, long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, String mutateProperty, @Nullable Map<String, Object> centralityDistribution, Map<String, Object> config) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, mutateMillis, config);
            this.mutateProperty = mutateProperty;
            this.centralityDistribution = centralityDistribution;
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static final class Builder
        extends AbstractCentralityResultBuilder<MutateResult> {
            public String mutateProperty;

            private Builder(ProcedureCallContext callContext, int concurrency) {
                super(callContext, concurrency);
            }

            public Builder withMutateProperty(String mutateProperty) {
                this.mutateProperty = mutateProperty;
                return this;
            }

            public MutateResult buildResult() {
                return new MutateResult(this.nodePropertiesWritten, this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.mutateMillis, this.mutateProperty, this.centralityHistogram, this.config.toMap());
            }
        }
    }
}

